/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.Sort;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;

public abstract class AbstractGetEntity<C extends Serializable, S extends PersistentObject>
implements TransactionContentWithResult<List<C>> {
    private final SearchEntityDescriptor searchDescriptor;
    private final int numberOfResults;
    private final int fromIndex;
    private final Sort sort;
    private List<C> clientObjects;

    public AbstractGetEntity(SearchEntityDescriptor searchDescriptor, int fromIndex, int numberOfResults, Sort sort) {
        this.searchDescriptor = searchDescriptor;
        this.numberOfResults = numberOfResults;
        this.fromIndex = fromIndex;
        this.sort = sort;
    }

    @Override
    public void execute() throws SBonitaException {
        if (this.searchDescriptor == null || this.sort == null) {
            throw new SBonitaReadException("Sort and SearchDescriptor cannot be null");
        }
        OrderByOption orderByOption = this.searchDescriptor.getEntityOrder(this.sort);
        QueryOptions searchOptions = new QueryOptions(this.fromIndex, this.numberOfResults, Collections.singletonList(orderByOption));
        List<S> serverObjects = this.executeGet(searchOptions);
        this.clientObjects = this.convertToClientObjects(serverObjects);
    }

    public abstract List<S> executeGet(QueryOptions var1) throws SBonitaException;

    public abstract List<C> convertToClientObjects(List<S> var1);

    @Override
    public List<C> getResult() {
        return this.clientObjects;
    }
}

