/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.profile.ProfileService;

public class DeleteGroups
extends DeleteWithActorMembers
implements TransactionContent {
    private final List<Long> groupIds;

    public DeleteGroups(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, List<Long> groupIds) {
        super(actorMappingService, profileService, identityService);
        this.groupIds = groupIds;
    }

    @Override
    public void execute() throws SBonitaException {
        ArrayList<Long> list = new ArrayList<Long>(this.groupIds);
        while (!list.isEmpty()) {
            Long groupId = list.get(0);
            this.deleteMembershipsByGroup(groupId);
            this.deleteActorMembersOfGroup(groupId);
            this.deleteProfileMembersOfGroup(groupId);
            List<Long> deleteChildrenGroup = this.getIdentityService().deleteChildrenGroup(groupId);
            list.removeAll(deleteChildrenGroup);
            this.getIdentityService().deleteGroup(groupId);
            list.remove(0);
        }
    }
}

