/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.api.impl.transaction.process.DeleteArchivedProcessInstances;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class DeleteProcess
extends DeleteArchivedProcessInstances {
    private final ProcessDefinitionService processDefinitionService;
    private final ActorMappingService actorMappingService;
    private final ClassLoaderService classLoaderService;

    public DeleteProcess(TenantServiceAccessor tenantAccessor, long processDefinitionId) {
        super(tenantAccessor, processDefinitionId);
        this.processDefinitionService = tenantAccessor.getProcessDefinitionService();
        this.actorMappingService = tenantAccessor.getActorMappingService();
        this.classLoaderService = tenantAccessor.getClassLoaderService();
    }

    @Override
    public void execute() throws SBonitaException {
        super.execute();
        this.actorMappingService.deleteActors(this.getProcessDefinitionId());
        try {
            this.processDefinitionService.delete(this.getProcessDefinitionId());
        }
        catch (SProcessDefinitionNotFoundException sProcessDefinitionNotFoundException) {
            // empty catch block
        }
        this.classLoaderService.removeLocalClassLoader(ScopeType.PROCESS.name(), this.getProcessDefinitionId());
    }
}

