/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.archive.impl;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.archive.ArchivingStrategy;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.persistence.PersistentObject;

public abstract class AbstractArchivingStrategy
implements ArchivingStrategy {
    protected final Map<String, Boolean> archives;

    public AbstractArchivingStrategy() {
        this.archives = new HashMap<String, Boolean>();
    }

    public AbstractArchivingStrategy(Map<String, Boolean> archives) {
        this.archives = archives;
    }

    @Override
    public boolean isArchivable(Class<? extends PersistentObject> srcClass) {
        Boolean isArchivable = this.archives.get(srcClass.getName());
        if (isArchivable == null) {
            throw new SBonitaRuntimeException("The class '" + srcClass.getName() + "' is not known as archivable");
        }
        return isArchivable;
    }
}

