/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.connector.impl;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.connector.ConnectorExecutor;
import org.bonitasoft.engine.connector.SConnector;
import org.bonitasoft.engine.connector.exception.SConnectorException;
import org.bonitasoft.engine.connector.impl.ConnectorExecutorThreadFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;
import org.bonitasoft.engine.tracking.TimeTracker;

public class ConnectorExecutorImpl
implements ConnectorExecutor {
    private ExecutorService executorService;
    private final SessionAccessor sessionAccessor;
    private final SessionService sessionService;
    private final int queueCapacity;
    private final int corePoolSize;
    private final int maximumPoolSize;
    private final long keepAliveTimeSeconds;
    private final TechnicalLoggerService loggerService;
    private final TimeTracker timeTracker;

    public ConnectorExecutorImpl(int queueCapacity, int corePoolSize, TechnicalLoggerService loggerService, int maximumPoolSize, long keepAliveTimeSeconds, SessionAccessor sessionAccessor, SessionService sessionService, TimeTracker timeTracker) {
        this.queueCapacity = queueCapacity;
        this.corePoolSize = corePoolSize;
        this.loggerService = loggerService;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
        this.sessionAccessor = sessionAccessor;
        this.sessionService = sessionService;
        this.timeTracker = timeTracker;
    }

    @Override
    public Map<String, Object> execute(SConnector sConnector, Map<String, Object> inputParameters) throws SConnectorException {
        long startTime = System.currentTimeMillis();
        if (this.executorService == null) {
            throw new SConnectorException("Unable to execute a connector, if the node is not started. Start it first");
        }
        ExecuteConnectorCallable callable = new ExecuteConnectorCallable(inputParameters, sConnector);
        Future<Map<String, Object>> submit = this.executorService.submit(callable);
        try {
            Map<String, Object> map = this.getValue(submit);
            return map;
        }
        catch (InterruptedException e) {
            this.disconnectSilently(sConnector);
            throw new SConnectorException(e);
        }
        catch (ExecutionException e) {
            this.disconnectSilently(sConnector);
            throw new SConnectorException(e);
        }
        catch (TimeoutException e) {
            submit.cancel(true);
            this.disconnectSilently(sConnector);
            throw new SConnectorException("The connector timed out " + sConnector);
        }
        finally {
            this.track("EXECUTE_CONNECTOR_INCLUDING_POOL_SUBMIT", startTime, sConnector, inputParameters);
        }
    }

    private void track(String recordName, long startTime, SConnector sConnector, Map<String, Object> inputParameters) {
        if (this.timeTracker.isTrackable(recordName)) {
            long endTime = System.currentTimeMillis();
            StringBuilder desc = new StringBuilder();
            desc.append("Connector: ");
            desc.append(sConnector);
            desc.append(" - ");
            desc.append("inputParameters: ");
            desc.append(inputParameters);
            this.timeTracker.track(recordName, desc.toString(), endTime - startTime);
        }
    }

    protected Map<String, Object> getValue(Future<Map<String, Object>> submit) throws InterruptedException, ExecutionException, TimeoutException {
        return submit.get();
    }

    void disconnectSilently(SConnector sConnector) {
        block2: {
            try {
                sConnector.disconnect();
            }
            catch (Exception t) {
                if (!this.loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) break block2;
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "An error occured while disconnecting the connector: " + sConnector, t);
            }
        }
    }

    @Override
    public void disconnect(SConnector sConnector) throws SConnectorException {
        try {
            sConnector.disconnect();
        }
        catch (SConnectorException e) {
            throw e;
        }
        catch (Exception t) {
            throw new SConnectorException(t);
        }
    }

    @Override
    public void start() {
        if (this.executorService == null) {
            ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(this.queueCapacity);
            QueueRejectedExecutionHandler handler = new QueueRejectedExecutionHandler(this.loggerService);
            ConnectorExecutorThreadFactory threadFactory = new ConnectorExecutorThreadFactory("ConnectorExecutor");
            this.setExecutor(new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeSeconds, TimeUnit.SECONDS, workQueue, threadFactory, handler));
        }
    }

    void setExecutor(ExecutorService executorService) {
        this.executorService = executorService;
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                    this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "Timeout (5s) trying to stop the connector executor thread pool.");
                }
            }
            catch (InterruptedException e) {
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "Error while stopping the connector executor thread pool.", e);
            }
            this.executorService = null;
        }
    }

    @Override
    public void pause() throws SBonitaException {
        this.stop();
    }

    @Override
    public void resume() throws SBonitaException {
        this.start();
    }

    private final class QueueRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final TechnicalLoggerService logger;

        public QueueRejectedExecutionHandler(TechnicalLoggerService logger) {
            this.logger = logger;
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "The work was rejected. Requeue work : " + task.toString());
            }
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Queuing " + task + " got interrupted.", e);
            }
        }
    }

    final class ExecuteConnectorCallable
    implements Callable<Map<String, Object>> {
        private final Map<String, Object> inputParameters;
        private final SConnector sConnector;

        private ExecuteConnectorCallable(Map<String, Object> inputParameters, SConnector sConnector) {
            this.inputParameters = inputParameters;
            this.sConnector = sConnector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> call() throws Exception {
            long startTime = System.currentTimeMillis();
            this.sConnector.setInputParameters(this.inputParameters);
            try {
                this.sConnector.validate();
                this.sConnector.connect();
                Map<String, Object> map = this.sConnector.execute();
                return map;
            }
            finally {
                try {
                    long sessionId = ConnectorExecutorImpl.this.sessionAccessor.getSessionId();
                    ConnectorExecutorImpl.this.sessionAccessor.deleteSessionId();
                    ConnectorExecutorImpl.this.sessionService.deleteSession(sessionId);
                }
                catch (SessionIdNotSetException e) {}
                ConnectorExecutorImpl.this.track("EXECUTE_CONNECTOR_CALLABLE", startTime, this.sConnector, this.inputParameters);
            }
        }
    }
}

