/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SMultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SMultiInstanceActivityInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class InitializingMultiInstanceActivityStateImpl
implements FlowNodeState {
    private final ExpressionResolverService expressionResolverService;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final ActivityInstanceService activityInstanceService;
    private final DataInstanceService dataInstanceService;
    private final StateBehaviors stateBehaviors;

    public InitializingMultiInstanceActivityStateImpl(ExpressionResolverService expressionResolverService, BPMInstancesCreator bpmInstancesCreator, ActivityInstanceService activityInstanceService, DataInstanceService dataInstanceService, StateBehaviors stateBehaviors) {
        this.expressionResolverService = expressionResolverService;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.activityInstanceService = activityInstanceService;
        this.dataInstanceService = dataInstanceService;
        this.stateBehaviors = stateBehaviors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        try {
            SDataInstance loopDataInput;
            this.stateBehaviors.createAttachedBoundaryEvents(processDefinition, (SActivityInstance)flowNodeInstance);
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SActivityDefinition activity = (SActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            SMultiInstanceActivityInstance multiInstanceActivity = (SMultiInstanceActivityInstance)this.activityInstanceService.getFlowNodeInstance(flowNodeInstance.getId());
            SLoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
            this.bpmInstancesCreator.addChildDataContainer(flowNodeInstance);
            if (!(loopCharacteristics instanceof SMultiInstanceLoopCharacteristics)) return StateCode.DONE;
            SMultiInstanceLoopCharacteristics miLoop = (SMultiInstanceLoopCharacteristics)loopCharacteristics;
            SExpression loopCardinality = miLoop.getLoopCardinality();
            int numberOfInstanceMax = -1;
            if (loopCardinality != null) {
                int intLoopCardinality = (Integer)this.expressionResolverService.evaluate(loopCardinality, new SExpressionContext((Long)multiInstanceActivity.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId()));
                this.activityInstanceService.setLoopCardinality(flowNodeInstance, intLoopCardinality);
                numberOfInstanceMax = intLoopCardinality;
            } else if (miLoop.getLoopDataInputRef() != null && (loopDataInput = this.dataInstanceService.getDataInstance(miLoop.getLoopDataInputRef(), flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name())) != null) {
                SDataInstance loopDataOutput;
                Serializable value = loopDataInput.getValue();
                if (!(value instanceof List)) throw new SActivityStateExecutionException("The multi instance on activity " + flowNodeInstance.getName() + " of process " + processDefinition.getName() + " " + processDefinition.getVersion() + " have a loop data input which is not a java.util.List");
                List loopDataInputCollection = (List)((Object)value);
                numberOfInstanceMax = loopDataInputCollection.size();
                String loopDataOutputRef = miLoop.getLoopDataOutputRef();
                if (loopDataOutputRef != null && (loopDataOutput = this.dataInstanceService.getDataInstance(loopDataOutputRef, flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name())) != null) {
                    Serializable outValue = loopDataOutput.getValue();
                    if (outValue instanceof List) {
                        List loopDataOutputCollection = (List)((Object)outValue);
                        if (loopDataOutputCollection.size() < numberOfInstanceMax) {
                            ArrayList newOutputList = new ArrayList(numberOfInstanceMax);
                            newOutputList.addAll(loopDataOutputCollection);
                            for (int i = loopDataOutputCollection.size(); i < numberOfInstanceMax; ++i) {
                                newOutputList.add(null);
                            }
                            EntityUpdateDescriptor updateDescriptor = new EntityUpdateDescriptor();
                            SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
                            updateDescriptor.addField(fact.getValueKey(), newOutputList);
                            this.dataInstanceService.updateDataInstance(loopDataOutput, updateDescriptor);
                        }
                    } else {
                        if (outValue != null) throw new SActivityStateExecutionException("The multi instance on activity " + flowNodeInstance.getName() + " of process " + processDefinition.getName() + " " + processDefinition.getVersion() + " have a loop data output which is not a java.util.List");
                        ArrayList<Object> newOutputList = new ArrayList<Object>(numberOfInstanceMax);
                        for (int i = 0; i < numberOfInstanceMax; ++i) {
                            newOutputList.add(null);
                        }
                        EntityUpdateDescriptor updateDescriptor = new EntityUpdateDescriptor();
                        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
                        updateDescriptor.addField(fact.getValueKey(), newOutputList);
                        this.dataInstanceService.updateDataInstance(loopDataOutput, updateDescriptor);
                    }
                }
            }
            if (numberOfInstanceMax < 0) {
                throw new SActivityStateExecutionException("The multi instance on activity " + flowNodeInstance.getName() + " of process " + processDefinition.getName() + " " + processDefinition.getVersion() + " did not have loop cardinality nor loop data input ref set");
            }
            InitializingMultiInstanceActivityStateImpl.createInnerInstances(this.bpmInstancesCreator, this.activityInstanceService, processDefinition.getId(), activity, flowNodeInstance, miLoop.isSequential() ? 1 : numberOfInstanceMax);
            return StateCode.DONE;
        }
        catch (SActivityStateExecutionException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    static List<SFlowNodeInstance> createInnerInstances(BPMInstancesCreator bpmInstancesCreator, ActivityInstanceService activityInstanceService, long processDefinitionId, SActivityDefinition activity, SFlowNodeInstance flowNodeInstance, int numberOfInstanceToCreate) throws SBonitaException {
        SMultiInstanceActivityInstanceBuilderFactory keyProvider = BuilderFactory.get(SMultiInstanceActivityInstanceBuilderFactory.class);
        long rootProcessInstanceId = flowNodeInstance.getLogicalGroup(keyProvider.getRootProcessInstanceIndex());
        long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(keyProvider.getParentProcessInstanceIndex());
        int nbOfcreatedInstances = 0;
        int nbOfInstances = ((SMultiInstanceActivityInstance)flowNodeInstance).getNumberOfInstances();
        ArrayList<SFlowNodeInstance> createdInstances = new ArrayList<SFlowNodeInstance>();
        for (int i = nbOfInstances; i < nbOfInstances + numberOfInstanceToCreate; ++i) {
            createdInstances.add(bpmInstancesCreator.createFlowNodeInstance(processDefinitionId, flowNodeInstance.getRootContainerId(), flowNodeInstance.getId(), SFlowElementsContainerType.FLOWNODE, activity, rootProcessInstanceId, parentProcessInstanceId, true, i, SStateCategory.NORMAL, -1L, null));
            ++nbOfcreatedInstances;
        }
        SMultiInstanceActivityInstance multiInstanceActivityInstance = (SMultiInstanceActivityInstance)flowNodeInstance;
        activityInstanceService.addMultiInstanceNumberOfActiveActivities(multiInstanceActivityInstance, nbOfcreatedInstances);
        int tokenCount = multiInstanceActivityInstance.getTokenCount() + nbOfcreatedInstances;
        activityInstanceService.setTokenCount(multiInstanceActivityInstance, tokenCount);
        return createdInstances;
    }

    @Override
    public int getId() {
        return 27;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "initializing";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return true;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return true;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

