/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.authentication.impl;

import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.authentication.PlatformAuthenticationService;
import org.bonitasoft.engine.platform.authentication.SInvalidPasswordException;
import org.bonitasoft.engine.platform.authentication.SInvalidUserException;

public class PlatformAuthenticationServiceImpl
implements PlatformAuthenticationService {
    private static final String USERNAME = "platformAdmin";
    private static final String PASSWORD = "platform";
    private final TechnicalLoggerService logger;

    public PlatformAuthenticationServiceImpl(TechnicalLoggerService logger) {
        this.logger = logger;
    }

    @Override
    public void checkUserCredentials(String username, String password) throws SInvalidUserException, SInvalidPasswordException {
        String methodName = "checkUserCredentials";
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "checkUserCredentials"));
        }
        if (!USERNAME.equals(username)) {
            this.logOnExceptionMethod(username, "checkUserCredentials");
            throw new SInvalidUserException("Invalid user : " + username);
        }
        if (!PASSWORD.equals(password)) {
            this.logOnExceptionMethod(username, "checkUserCredentials");
            throw new SInvalidPasswordException("Invalid password");
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "checkUserCredentials"));
        }
    }

    private void logOnExceptionMethod(String username, String methodName) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, "Invalid user : " + username));
        }
    }
}

