/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.profile;

import java.util.List;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.profile.Profile;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchProfileDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;

public class SearchProfiles
extends AbstractSearchEntity<Profile, SProfile> {
    private final ProfileService profileService;

    public SearchProfiles(ProfileService profileService, SearchProfileDescriptor searchProfileDescriptor, SearchOptions options) {
        super(searchProfileDescriptor, options);
        this.profileService = profileService;
    }

    @Override
    public long executeCount(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.profileService.getNumberOfProfiles(queryOptions);
    }

    @Override
    public List<SProfile> executeSearch(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.profileService.searchProfiles(queryOptions);
    }

    @Override
    public List<Profile> convertToClientObjects(List<SProfile> serverObjects) {
        return ModelConvertor.toProfiles(serverObjects);
    }
}

