/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.tracking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.bonitasoft.engine.commons.TenantLifecycleService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.tracking.Clock;
import org.bonitasoft.engine.tracking.FlushEvent;
import org.bonitasoft.engine.tracking.FlushEventListener;
import org.bonitasoft.engine.tracking.FlushResult;
import org.bonitasoft.engine.tracking.FlushThread;
import org.bonitasoft.engine.tracking.Record;
import org.bonitasoft.engine.tracking.ThreadSleepClockImpl;

public class TimeTracker
implements TenantLifecycleService {
    private final Set<String> activatedRecords;
    private final FlushThread flushThread;
    private final List<? extends FlushEventListener> flushEventListeners;
    private final TechnicalLoggerService logger;
    private final Queue<Record> records;
    private boolean started;
    private final boolean startFlushThread;

    public TimeTracker(TechnicalLoggerService logger, boolean startFlushThread, List<? extends FlushEventListener> flushEventListeners, int maxSize, int flushIntervalInSeconds, String ... activatedRecords) {
        this(logger, new ThreadSleepClockImpl(), startFlushThread, flushEventListeners, maxSize, flushIntervalInSeconds * 1000, activatedRecords);
    }

    public TimeTracker(TechnicalLoggerService logger, Clock clock, boolean startFlushThread, List<? extends FlushEventListener> flushEventListeners, int maxSize, int flushIntervalInSeconds, String ... activatedRecords) {
        this.startFlushThread = startFlushThread;
        this.started = false;
        this.logger = logger;
        this.flushEventListeners = flushEventListeners;
        this.activatedRecords = activatedRecords == null || activatedRecords.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(activatedRecords));
        if (activatedRecords != null && activatedRecords.length > 0 && logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Time tracker is activated for some records. This may not be used in production as performances may be strongly impacted: " + activatedRecords);
        }
        this.flushThread = new FlushThread(clock, flushIntervalInSeconds, this, logger);
        this.records = new CircularFifoQueue(maxSize);
    }

    public boolean isTrackable(String recordName) {
        return this.started && this.activatedRecords.contains(recordName);
    }

    public void track(String recordName, String recordDescription, long duration) {
        if (this.isTrackable(recordName)) {
            long timestamp = System.currentTimeMillis();
            Record record = new Record(timestamp, recordName, recordDescription, duration);
            this.track(record);
        }
    }

    public void track(Record record) {
        if (this.isTrackable(record.getName())) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Tracking record: " + record);
            }
            this.records.add(record);
        }
    }

    public List<FlushResult> flush() {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Flushing...");
        }
        List<Record> records = this.getRecords();
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Flushing...");
        }
        FlushEvent flushEvent = new FlushEvent(records);
        ArrayList<FlushResult> flushResults = new ArrayList<FlushResult>();
        if (this.flushEventListeners != null) {
            for (FlushEventListener flushEventListener : this.flushEventListeners) {
                try {
                    flushResults.add(flushEventListener.flush(flushEvent));
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) continue;
                    this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "Exception while flushing: " + flushEvent + " on listener " + flushEventListener);
                }
            }
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Flush finished: " + flushEvent);
        }
        return flushResults;
    }

    public List<Record> getRecords() {
        return Arrays.asList(this.records.toArray(new Record[0]));
    }

    @Override
    public void start() throws SBonitaException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Starting TimeTracker...");
        }
        if (this.startFlushThread && !this.flushThread.isAlive()) {
            this.flushThread.start();
        }
        this.started = true;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "TimeTracker started.");
        }
    }

    @Override
    public void stop() throws SBonitaException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Stopping TimeTracker...");
        }
        if (this.flushThread.isAlive()) {
            this.flushThread.interrupt();
        }
        this.started = false;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "TimeTracker stopped.");
        }
    }

    @Override
    public void pause() throws SBonitaException {
    }

    @Override
    public void resume() throws SBonitaException {
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFlushThreadAlive() {
        return this.flushThread.isAlive();
    }
}

