/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.concurrent.TimeUnit;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.work.AbstractWorkSynchronization;
import org.bonitasoft.engine.work.BonitaExecutorService;
import org.bonitasoft.engine.work.BonitaExecutorServiceFactory;
import org.bonitasoft.engine.work.BonitaWork;
import org.bonitasoft.engine.work.SWorkException;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;
import org.bonitasoft.engine.work.WorkSynchronizationFactory;

public class ExecutorWorkService
implements WorkService {
    private final Object getSynchroLock = new Object();
    private final TransactionService transactionService;
    private final WorkSynchronizationFactory workSynchronizationFactory;
    private final ThreadLocal<AbstractWorkSynchronization> synchronizations = new ThreadLocal();
    private final TechnicalLoggerService loggerService;
    private final SessionAccessor sessionAccessor;
    private final BonitaExecutorServiceFactory bonitaExecutorServiceFactory;
    private BonitaExecutorService executor;
    private final int workTerminationTimeout;

    public ExecutorWorkService(TransactionService transactionService, WorkSynchronizationFactory workSynchronizationFactory, TechnicalLoggerService loggerService, SessionAccessor sessionAccessor, BonitaExecutorServiceFactory bonitaExecutorServiceFactory, int workTerminationTimeout) {
        this.transactionService = transactionService;
        this.workSynchronizationFactory = workSynchronizationFactory;
        this.loggerService = loggerService;
        this.sessionAccessor = sessionAccessor;
        this.bonitaExecutorServiceFactory = bonitaExecutorServiceFactory;
        this.workTerminationTimeout = workTerminationTimeout;
    }

    @Override
    public void registerWork(BonitaWork work) throws SWorkRegisterException {
        if (this.isStopped()) {
            this.logExecutorStateWarn(work);
            return;
        }
        AbstractWorkSynchronization synchro = this.getContinuationSynchronization();
        if (synchro != null) {
            synchro.addWork(work);
        }
    }

    private void logExecutorStateWarn(BonitaWork work) {
        this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "Tried to register work " + work.getDescription() + ", but the work service is stopped.");
    }

    @Override
    public void executeWork(BonitaWork work) throws SWorkRegisterException {
        if (this.isStopped()) {
            this.logExecutorStateWarn(work);
            return;
        }
        try {
            work.setTenantId(this.sessionAccessor.getTenantId());
        }
        catch (STenantIdNotSetException e) {
            throw new SWorkRegisterException("Unable to read tenant id from session.", e);
        }
        this.executor.submit(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractWorkSynchronization getContinuationSynchronization() throws SWorkRegisterException {
        Object object = this.getSynchroLock;
        synchronized (object) {
            AbstractWorkSynchronization synchro = this.synchronizations.get();
            if (synchro == null) {
                synchro = this.workSynchronizationFactory.getWorkSynchronization(this.executor, this.loggerService, this.sessionAccessor, this);
                try {
                    this.transactionService.registerBonitaSynchronization(synchro);
                }
                catch (STransactionNotFoundException e) {
                    throw new SWorkRegisterException(e.getMessage(), e);
                }
                this.synchronizations.set(synchro);
            }
            return synchro;
        }
    }

    @Override
    public boolean isStopped() {
        return this.executor == null;
    }

    @Override
    public synchronized void stop() {
        try {
            if (this.isStopped()) {
                return;
            }
            this.shutdownExecutor();
            this.awaitTermination();
        }
        catch (SWorkException e) {
            if (e.getCause() != null) {
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, e.getMessage(), e.getCause());
            }
            this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, e.getMessage());
        }
    }

    @Override
    public synchronized void start() {
        if (this.isStopped()) {
            this.executor = this.bonitaExecutorServiceFactory.createExecutorService();
        }
    }

    @Override
    public synchronized void pause() throws SWorkException {
        if (this.isStopped()) {
            return;
        }
        this.shutdownExecutor();
        this.executor.clearAllQueues();
        this.awaitTermination();
    }

    @Override
    public synchronized void resume() {
        this.start();
    }

    private void awaitTermination() throws SWorkException {
        try {
            if (!this.executor.awaitTermination(this.workTerminationTimeout, TimeUnit.SECONDS)) {
                throw new SWorkException("Waited termination of all work " + this.workTerminationTimeout + "s but all tasks were not finished");
            }
        }
        catch (InterruptedException e) {
            throw new SWorkException("Interrupted while stopping the work service", e);
        }
        this.executor = null;
    }

    private void shutdownExecutor() {
        this.executor.shutdownAndEmptyQueue();
        this.loggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "Stopped executor service");
    }

    @Override
    public void notifyNodeStopped(String nodeName) {
        if (!this.isStopped()) {
            this.executor.notifyNodeStopped(nodeName);
        }
    }

    @Override
    public void removeSynchronization() {
        this.synchronizations.remove();
    }
}

