/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.bonitasoft.engine.commons.StringUtils;

public class DeepRegexFileFilter
extends AbstractFileFilter {
    private final Pattern regExPattern;

    public DeepRegexFileFilter(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.regExPattern = Pattern.compile(pattern);
    }

    public DeepRegexFileFilter(File parentDir, String pattern) {
        this(StringUtils.uniformizePathPattern(parentDir.getAbsolutePath()) + "/" + pattern);
    }

    public boolean accept(File file) {
        String fullName = StringUtils.uniformizePathPattern(file.getAbsolutePath());
        return this.regExPattern.matcher(fullName).matches();
    }
}

