/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.model.STenant;

public class GetTenantsCallable
implements Callable<List<STenant>> {
    private final PlatformService platformService;

    public GetTenantsCallable(PlatformService platformService) {
        this.platformService = platformService;
    }

    @Override
    public List<STenant> call() throws Exception {
        List<STenant> tenants;
        int maxResults = 100;
        int i = 0;
        ArrayList<STenant> tenantIds = new ArrayList<STenant>();
        do {
            tenants = this.platformService.getTenants(new QueryOptions(i, 100, STenant.class, "id", OrderByType.ASC));
            i += 100;
            for (STenant sTenant : tenants) {
                tenantIds.add(sTenant);
            }
        } while (tenants.size() == 100);
        return tenantIds;
    }
}

