/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.builder.SContactInfoBuilderFactory;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class UpdateUser
implements TransactionContentWithResult<SUser> {
    private SUser sUser;
    private final long userId;
    private final IdentityService identityService;
    private final EntityUpdateDescriptor changeDescriptor;
    private final EntityUpdateDescriptor personalDataUpdateDescriptor;
    private final EntityUpdateDescriptor professionalDataUpdateDescriptor;

    public UpdateUser(IdentityService identityService, long userId, EntityUpdateDescriptor changeDescriptor, EntityUpdateDescriptor personalDataUpDescriptor, EntityUpdateDescriptor professionalDataUpDescriptor) {
        this.userId = userId;
        this.personalDataUpdateDescriptor = personalDataUpDescriptor;
        this.professionalDataUpdateDescriptor = professionalDataUpDescriptor;
        this.sUser = null;
        this.identityService = identityService;
        this.changeDescriptor = changeDescriptor;
    }

    public UpdateUser(IdentityService identityService, SUser sUser, EntityUpdateDescriptor changeDescriptor, EntityUpdateDescriptor personalDataUpDescriptor, EntityUpdateDescriptor professionalDataUpDescriptor) {
        this.userId = -1L;
        this.personalDataUpdateDescriptor = personalDataUpDescriptor;
        this.professionalDataUpdateDescriptor = professionalDataUpDescriptor;
        this.sUser = sUser;
        this.identityService = identityService;
        this.changeDescriptor = changeDescriptor;
    }

    @Override
    public void execute() throws SBonitaException {
        if (this.changeDescriptor != null && !this.changeDescriptor.getFields().isEmpty()) {
            if (this.sUser == null) {
                this.sUser = this.identityService.getUser(this.userId);
            }
            this.identityService.updateUser(this.sUser, this.changeDescriptor);
        }
        if (this.personalDataUpdateDescriptor != null && !this.personalDataUpdateDescriptor.getFields().isEmpty()) {
            SContactInfo persoContactInfo = this.identityService.getUserContactInfo(this.userId, true);
            if (persoContactInfo == null) {
                persoContactInfo = BuilderFactory.get(SContactInfoBuilderFactory.class).createNewInstance(this.userId, true).done();
                this.identityService.createUserContactInfo(persoContactInfo);
            }
            this.identityService.updateUserContactInfo(persoContactInfo, this.personalDataUpdateDescriptor);
        }
        if (this.professionalDataUpdateDescriptor != null && !this.professionalDataUpdateDescriptor.getFields().isEmpty()) {
            SContactInfo professContactInfo = this.identityService.getUserContactInfo(this.userId, false);
            if (professContactInfo == null) {
                professContactInfo = BuilderFactory.get(SContactInfoBuilderFactory.class).createNewInstance(this.userId, false).done();
                this.identityService.createUserContactInfo(professContactInfo);
            }
            this.identityService.updateUserContactInfo(professContactInfo, this.professionalDataUpdateDescriptor);
        }
        this.sUser = this.sUser == null ? this.identityService.getUser(this.userId) : this.identityService.getUser(this.sUser.getId());
    }

    @Override
    public SUser getResult() {
        return this.sUser;
    }
}

