/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.connector;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.PermissionAPI;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.api.ThemeAPI;
import org.bonitasoft.engine.api.impl.ClientInterceptor;
import org.bonitasoft.engine.api.impl.ServerAPIFactory;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class ConnectorAPIAccessorImpl
implements APIAccessor {
    private static final long serialVersionUID = 3365911149008207537L;
    private final long tenantId;
    private APISession apiSession;

    public ConnectorAPIAccessorImpl(long tenantId) {
        this.tenantId = tenantId;
    }

    protected APISession getAPISession() {
        if (this.apiSession == null) {
            TenantServiceAccessor tenantServiceAccessor = TenantServiceSingleton.getInstance(this.tenantId);
            SessionAccessor sessionAccessor = tenantServiceAccessor.getSessionAccessor();
            SessionService sessionService = tenantServiceAccessor.getSessionService();
            try {
                SSession session = sessionService.createSession(this.tenantId, ConnectorAPIAccessorImpl.class.getSimpleName());
                sessionAccessor.setSessionInfo(session.getId(), this.tenantId);
                return ModelConvertor.toAPISession(session, null);
            }
            catch (BonitaRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BonitaRuntimeException((Throwable)e);
            }
        }
        return this.apiSession;
    }

    public IdentityAPI getIdentityAPI() {
        return ConnectorAPIAccessorImpl.getAPI(IdentityAPI.class, this.getAPISession());
    }

    public ProcessAPI getProcessAPI() {
        return ConnectorAPIAccessorImpl.getAPI(ProcessAPI.class, this.getAPISession());
    }

    public CommandAPI getCommandAPI() {
        return ConnectorAPIAccessorImpl.getAPI(CommandAPI.class, this.getAPISession());
    }

    public ProfileAPI getProfileAPI() {
        return ConnectorAPIAccessorImpl.getAPI(ProfileAPI.class, this.getAPISession());
    }

    public ThemeAPI getThemeAPI() {
        return ConnectorAPIAccessorImpl.getAPI(ThemeAPI.class, this.getAPISession());
    }

    public PermissionAPI getPermissionAPI() {
        return ConnectorAPIAccessorImpl.getAPI(PermissionAPI.class, this.getAPISession());
    }

    private static ServerAPI getServerAPI() {
        return ServerAPIFactory.getServerAPI(false);
    }

    private static <T> T getAPI(Class<T> clazz, APISession session) {
        ServerAPI serverAPI = ConnectorAPIAccessorImpl.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI, (Session)session);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }
}

