/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.document.api;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SObjectAlreadyExistsException;
import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectModificationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.core.document.model.SDocument;
import org.bonitasoft.engine.core.document.model.SDocumentMapping;
import org.bonitasoft.engine.core.document.model.SLightDocument;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.archive.SAMappedDocument;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.SRecorderException;

public interface DocumentService {
    public static final String DOCUMENT = "DOCUMENT";
    public static final String DOCUMENTMAPPING = "DOCUMENTMAPPING";
    public static final String SUPERVISED_BY = "SupervisedBy";

    public SMappedDocument attachDocumentToProcessInstance(SDocument var1, long var2, String var4, String var5) throws SObjectCreationException;

    public SMappedDocument attachDocumentToProcessInstance(SDocument var1, long var2, String var4, String var5, int var6) throws SObjectCreationException, SObjectAlreadyExistsException;

    public void removeCurrentVersion(SMappedDocument var1) throws SObjectModificationException;

    public void removeCurrentVersion(long var1, String var3) throws SObjectNotFoundException, SObjectModificationException;

    public byte[] getDocumentContent(String var1) throws SObjectNotFoundException;

    public SMappedDocument getMappedDocument(long var1) throws SObjectNotFoundException, SBonitaReadException;

    public SLightDocument getDocument(long var1) throws SObjectNotFoundException, SBonitaReadException;

    public SMappedDocument getMappedDocument(long var1, String var3) throws SObjectNotFoundException, SBonitaReadException;

    public List<SMappedDocument> getDocumentsOfProcessInstance(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public long getNumberOfDocumentsOfProcessInstance(long var1) throws SBonitaReadException;

    public SMappedDocument getMappedDocument(long var1, String var3, long var4) throws SObjectNotFoundException, SBonitaReadException;

    public long getNumberOfDocuments(QueryOptions var1) throws SBonitaReadException;

    public List<SMappedDocument> searchDocuments(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfDocumentsSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SMappedDocument> searchDocumentsSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfArchivedDocuments(QueryOptions var1) throws SBonitaReadException;

    public void removeDocument(SMappedDocument var1) throws SObjectModificationException;

    public List<SAMappedDocument> searchArchivedDocuments(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfArchivedDocumentsSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SAMappedDocument> searchArchivedDocumentsSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public SAMappedDocument getArchivedVersionOfProcessDocument(long var1) throws SObjectNotFoundException;

    public String generateDocumentURL(String var1, String var2);

    public SAMappedDocument getArchivedDocument(long var1) throws SObjectNotFoundException;

    public void deleteDocument(SLightDocument var1) throws SObjectModificationException;

    public void deleteDocumentsFromProcessInstance(Long var1) throws SBonitaReadException, SObjectModificationException;

    public void deleteArchivedDocuments(long var1) throws SObjectModificationException;

    public void archive(SDocumentMapping var1, long var2) throws SObjectModificationException;

    public void updateDocumentOfList(SMappedDocument var1, SDocument var2, int var3) throws SObjectModificationException;

    public void updateDocumentIndex(SMappedDocument var1, int var2) throws SObjectModificationException;

    public List<SMappedDocument> getDocumentList(String var1, long var2, int var4, int var5) throws SBonitaReadException;

    public SMappedDocument updateDocument(SDocumentMapping var1, SDocument var2) throws SObjectModificationException;

    public List<SMappedDocument> getDocumentList(String var1, long var2, long var4) throws SBonitaReadException;

    public void deleteContentOfArchivedDocument(long var1) throws SObjectNotFoundException, SBonitaReadException, SRecorderException;

    public SMappedDocument updateDocument(long var1, SDocument var3) throws SObjectNotFoundException, SObjectModificationException, SBonitaReadException;
}

