/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.document.model.impl;

import org.bonitasoft.engine.core.document.model.SDocumentMapping;
import org.bonitasoft.engine.core.document.model.SLightDocument;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.archive.SADocumentMapping;

public class SMappedDocumentImpl
implements SMappedDocument {
    private long id;
    private long tenantId;
    private long documentId;
    private long processInstanceId;
    private String name;
    private String description;
    private String version;
    private int index;
    private SLightDocument document;

    public SMappedDocumentImpl() {
    }

    public SMappedDocumentImpl(SDocumentMapping documentMapping, SLightDocument document) {
        this.id = documentMapping.getId();
        this.name = documentMapping.getName();
        this.description = documentMapping.getDescription();
        this.version = documentMapping.getVersion();
        this.document = document;
        this.documentId = documentMapping.getDocumentId();
        this.processInstanceId = documentMapping.getProcessInstanceId();
        this.index = documentMapping.getIndex();
    }

    public SMappedDocumentImpl(SADocumentMapping documentMapping, SLightDocument document) {
        this.id = documentMapping.getSourceObjectId();
        this.document = document;
        this.documentId = documentMapping.getDocumentId();
        this.processInstanceId = documentMapping.getProcessInstanceId();
        this.name = documentMapping.getName();
        this.description = documentMapping.getDescription();
        this.version = documentMapping.getVersion();
        this.index = documentMapping.getIndex();
    }

    @Override
    public long getDocumentId() {
        return this.documentId;
    }

    @Override
    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setDocumentId(long documentId) {
        this.documentId = documentId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public SLightDocument getDocument() {
        return this.document;
    }

    public void setDocument(SLightDocument document) {
        this.document = document;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public long getAuthor() {
        return this.document.getAuthor();
    }

    @Override
    public long getCreationDate() {
        return this.document.getCreationDate();
    }

    @Override
    public String getMimeType() {
        return this.document.getMimeType();
    }

    @Override
    public String getFileName() {
        return this.document.getFileName();
    }

    @Override
    public boolean hasContent() {
        return this.document.hasContent();
    }

    @Override
    public String getUrl() {
        return this.document.getUrl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getDiscriminator() {
        return SMappedDocumentImpl.class.getName();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMappedDocumentImpl that = (SMappedDocumentImpl)o;
        if (this.documentId != that.documentId) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.processInstanceId != that.processInstanceId) {
            return false;
        }
        if (this.tenantId != that.tenantId) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.document != null ? !this.document.equals(that.document) : that.document != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.tenantId ^ this.tenantId >>> 32);
        result = 31 * result + (int)(this.documentId ^ this.documentId >>> 32);
        result = 31 * result + (int)(this.processInstanceId ^ this.processInstanceId >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + this.index;
        result = 31 * result + (this.document != null ? this.document.hashCode() : 0);
        return result;
    }
}

