/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.api;

import java.util.List;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceHierarchicalDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public interface ProcessInstanceService {
    public static final String PROCESSINSTANCE = "PROCESSINSTANCE";
    public static final String PROCESSINSTANCE_STATE = "PROCESSINSTANCE_STATE";
    public static final String MIGRATION_PLAN = "MIGRATION_PLAN";
    public static final String PROCESS_INSTANCE_CATEGORY_STATE = "PROCESS_INSTANCE_CATEGORY_STATE";
    public static final String PROCESSINSTANCE_STATE_UPDATED = "PROCESSINSTANCE_STATE_UPDATED";
    public static final String PROCESSINSTANCE_TOKEN_COUNT = "ACTIVITY_INSTANCE_TOKEN_COUNT";
    public static final String EVENT_TRIGGER_INSTANCE = "EVENT_TRIGGER_INSTANCE";

    public void createProcessInstance(SProcessInstance var1) throws SProcessInstanceCreationException;

    public void deleteProcessInstance(long var1) throws SProcessInstanceNotFoundException, SProcessInstanceReadException, SFlowNodeReadException, SProcessInstanceModificationException, SProcessInstanceHierarchicalDeletionException;

    public void deleteProcessInstance(SProcessInstance var1) throws SFlowNodeReadException, SProcessInstanceModificationException, SProcessInstanceHierarchicalDeletionException;

    public long deleteParentProcessInstanceAndElements(List<SProcessInstance> var1) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException;

    public void deleteParentProcessInstanceAndElements(long var1) throws SProcessInstanceReadException, SProcessInstanceNotFoundException, SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException;

    public void deleteParentProcessInstanceAndElements(SProcessInstance var1) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException;

    public SProcessInstance getProcessInstance(long var1) throws SProcessInstanceNotFoundException, SProcessInstanceReadException;

    public void setState(SProcessInstance var1, ProcessInstanceState var2) throws SProcessInstanceNotFoundException, SProcessInstanceModificationException;

    public void setStateCategory(SProcessInstance var1, SStateCategory var2) throws SProcessInstanceNotFoundException, SProcessInstanceModificationException;

    public void deleteArchivedProcessInstance(SAProcessInstance var1) throws SProcessInstanceModificationException, SFlowNodeReadException;

    public long deleteArchivedParentProcessInstancesAndElements(List<SAProcessInstance> var1) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException;

    public void deleteArchivedParentProcessInstanceAndElements(SAProcessInstance var1) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException;

    public void deleteArchivedProcessInstanceElements(long var1, long var3) throws SFlowNodeReadException, SProcessInstanceModificationException;

    public List<Long> getChildInstanceIdsOfProcessInstance(long var1, int var3, int var4, String var5, OrderByType var6) throws SProcessInstanceReadException;

    public SProcessInstance getChildOfActivity(long var1) throws SProcessInstanceNotFoundException, SBonitaReadException;

    public long getNumberOfChildInstancesOfProcessInstance(long var1) throws SProcessInstanceReadException;

    public List<SAProcessInstance> getArchivedProcessInstancesInAllStates(List<Long> var1) throws SProcessInstanceReadException;

    public long getNumberOfArchivedProcessInstances(QueryOptions var1) throws SBonitaReadException;

    public List<SAProcessInstance> searchArchivedProcessInstances(QueryOptions var1) throws SBonitaReadException;

    public SAProcessInstance getArchivedProcessInstance(long var1) throws SProcessInstanceReadException;

    public long getNumberOfProcessInstances(QueryOptions var1) throws SBonitaReadException;

    public List<SProcessInstance> searchProcessInstances(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfOpenProcessInstancesSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SProcessInstance> searchOpenProcessInstancesSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfOpenProcessInstancesInvolvingUser(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SProcessInstance> searchOpenProcessInstancesInvolvingUser(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfOpenProcessInstancesInvolvingUsersManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SProcessInstance> searchOpenProcessInstancesInvolvingUsersManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<Long> getArchivedChildrenSourceObjectIdsFromRootProcessInstance(long var1, int var3, int var4, OrderByType var5) throws SBonitaReadException;

    public long getNumberOfArchivedProcessInstancesWithoutSubProcess(QueryOptions var1) throws SBonitaReadException;

    public List<SAProcessInstance> searchArchivedProcessInstancesWithoutSubProcess(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfArchivedProcessInstancesSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SAProcessInstance> searchArchivedProcessInstancesSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfArchivedProcessInstancesInvolvingUser(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SAProcessInstance> searchArchivedProcessInstancesInvolvingUser(long var1, QueryOptions var3) throws SBonitaReadException;

    public void updateProcess(SProcessInstance var1, EntityUpdateDescriptor var2) throws SProcessInstanceModificationException;

    public void setMigrationPlanId(SProcessInstance var1, long var2) throws SProcessInstanceModificationException;

    public void deleteFlowNodeInstance(SFlowNodeInstance var1, SProcessDefinition var2) throws SFlowNodeReadException, SProcessInstanceModificationException;

    public List<Long> getSourceProcesInstanceIdsOfArchProcessInstancesFromDefinition(long var1, int var3, int var4, OrderByType var5) throws SProcessInstanceReadException;

    public List<SProcessInstance> getProcessInstancesInState(QueryOptions var1, ProcessInstanceState var2) throws SProcessInstanceReadException;

    public List<SProcessInstance> getProcessInstancesInStates(QueryOptions var1, ProcessInstanceState ... var2) throws SProcessInstanceReadException;

    public void deleteArchivedProcessInstancesOfProcessInstance(long var1) throws SBonitaException;

    public SAProcessInstance getLastArchivedProcessInstance(long var1) throws SBonitaReadException;

    public long getNumberOfFailedProcessInstances(QueryOptions var1) throws SBonitaReadException;

    public List<SProcessInstance> searchFailedProcessInstances(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfProcessInstances(long var1) throws SBonitaReadException;
}

