/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.recorder;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SHiddenTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SToken;
import org.bonitasoft.engine.core.process.instance.model.SUserTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageEventCouple;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingErrorEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingSignalEvent;
import org.bonitasoft.engine.core.process.instance.model.event.trigger.SEventTriggerInstance;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;

public class SelectDescriptorBuilder {
    public static <T extends PersistentObject> SelectByIdDescriptor<T> getElementById(Class<T> clazz, String elementName, long id) {
        return new SelectByIdDescriptor<T>("get" + elementName + "ById", clazz, id);
    }

    public static SelectOneDescriptor<SHiddenTaskInstance> getSHiddenTask(long userId, long activityInstanceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("userId", userId);
        parameters.put("activityInstanceId", activityInstanceId);
        return new SelectOneDescriptor<SHiddenTaskInstance>("getSHiddenTaskByUserAndActivity", parameters, SHiddenTaskInstance.class);
    }

    public static SelectListDescriptor<SHiddenTaskInstance> getSHiddenTasksForActivity(long activityInstanceId, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("activityInstanceId", activityInstanceId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SHiddenTaskInstance>("getSHiddenTasksForActivity", parameters, SHiddenTaskInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SFlowNodeInstance> getFlowNodesFromProcessInstance(long rootContainerId, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SFlowNodeInstance>("getFlowNodesFromProcessInstance", parameters, SFlowNodeInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SAFlowNodeInstance> getArchivedFlowNodesFromProcessInstance(long rootContainerId, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SAFlowNodeInstance>("getArchivedFlowNodesFromProcessInstance", parameters, SAFlowNodeInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SAActivityInstance> getArchivedActivitiesFromProcessInstance(long rootContainerId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        return new SelectListDescriptor<SAActivityInstance>("getAActivitiesFromProcessInstance", parameters, SAActivityInstance.class, queryOptions);
    }

    public static SelectListDescriptor<Long> getSourceProcesInstanceIdsOfArchProcessInstancesFromDefinition(long processDefinitionId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap("processDefinitionId", processDefinitionId);
        return new SelectListDescriptor<Long>("getSourceProcessInstanceIdsByProcessDefinitionId", parameters, SAProcessInstance.class, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectListDescriptor("get" + elementName + "s", parameters, clazz, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElements(Class<T> clazz, String elementName, int fromIndex, int numberOfElements) {
        Map<String, Object> map = Collections.emptyMap();
        return new SelectListDescriptor("get" + elementName + "s", map, clazz, new QueryOptions(fromIndex, numberOfElements));
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getActivitiesWithStates(Class<T> clazz, long processInstanceId, Set<Integer> stateIds, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("stateIds", stateIds);
        parameters.put("processInstanceId", processInstanceId);
        return new SelectListDescriptor("getActivitiesWithStates", parameters, clazz, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getSpecificQueryWithParameters(Class<T> clazz, String queryName, Map<String, Object> parameters, QueryOptions queryOptions) {
        return new SelectListDescriptor(queryName, parameters, clazz, queryOptions);
    }

    public static SelectListDescriptor<SHumanTaskInstance> getAssignedUserTasks(long userId, int fromIndex, int maxResults, String sortFieldName, OrderByType order) {
        Map<String, Object> parameters = Collections.singletonMap("assigneeId", userId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults, SActivityInstance.class, sortFieldName, order);
        return new SelectListDescriptor<SHumanTaskInstance>("getAssignedUserTasks", parameters, SHumanTaskInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SHumanTaskInstance> getPendingUserTasks(long userId, Set<Long> actorIds, int fromIndex, int maxResults, String sortFieldName, OrderByType order) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("actorIds", actorIds);
        parameters.put("userId", userId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults, SActivityInstance.class, sortFieldName, order);
        return new SelectListDescriptor<SHumanTaskInstance>("getPendingUserTasks", parameters, SHumanTaskInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SHumanTaskInstance> getPendingUserTasks(long userId, int fromIndex, int maxResults, String sortFieldName, OrderByType order) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("userId", userId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults, SActivityInstance.class, sortFieldName, order);
        return new SelectListDescriptor<SHumanTaskInstance>("getPendingUserTasksWithoutActorIds", parameters, SHumanTaskInstance.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfProcessInstances() {
        Map<String, Object> emptyMap = Collections.emptyMap();
        return new SelectOneDescriptor<Long>("getNumberOfProcessInstances", emptyMap, SProcessInstance.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfArchivedProcessInstances() {
        Map<String, Object> emptyMap = Collections.emptyMap();
        return new SelectOneDescriptor<Long>("getNumberOfArchivedProcessInstances", emptyMap, SAProcessInstance.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfOpenActivities(long rootContainerId) {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        return new SelectOneDescriptor<Long>("getNumberOfOpenActivities", parameters, SActivityInstance.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfAssignedHumanTaskInstances(long userId) {
        Map<String, Object> parameters = Collections.singletonMap("assigneeId", userId);
        return new SelectOneDescriptor<Long>("getNumberOfAssignedUserTaskInstances", parameters, SHumanTaskInstance.class, Long.class);
    }

    public static SelectOneDescriptor<SGatewayInstance> getActiveGatewayInstanceOfProcess(long parentProcessInstanceId, String name) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("parentProcessInstanceId", parentProcessInstanceId);
        parameters.put("name", name);
        return new SelectOneDescriptor<SGatewayInstance>("getActiveGatewayInstanceOfProcess", parameters, SGatewayInstance.class);
    }

    public static SelectListDescriptor<SActivityInstance> getActivitiesFromProcessInstance(long rootContainerId, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SActivityInstance>("getActivitiesFromProcessInstance", parameters, SActivityInstance.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfActivitiesFromProcessInstance(long rootContainerId) {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        return new SelectOneDescriptor<Long>("getNumberOfActivitiesFromProcessInstance", parameters, SFlowNodeInstance.class, Long.class);
    }

    public static SelectListDescriptor<SEventInstance> getEventsFromRootContainer(long rootContainerId, int fromIndex, int maxResults, String field, OrderByType orderByType) {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults, SEventInstance.class, field, orderByType);
        return new SelectListDescriptor<SEventInstance>("getEventInstancesFromRootContainer", parameters, SEventInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SBoundaryEventInstance> getActivityBoundaryEvents(long activityInstanceId, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("activityInstanceId", activityInstanceId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SBoundaryEventInstance>("getActivityBoundaryEventInstances", parameters, SBoundaryEventInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SEventTriggerInstance> getEventTriggers(long eventInstanceId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap("eventInstanceId", eventInstanceId);
        return new SelectListDescriptor<SEventTriggerInstance>("getEventTriggerInstances", parameters, SEventTriggerInstance.class, queryOptions);
    }

    public static SelectListDescriptor<Long> getChildInstanceIdsOfProcessInstance(Class<SProcessInstance> class1, long processInstanceId, QueryOptions queryOptions) {
        Map<String, Object> map = Collections.singletonMap("processInstanceId", processInstanceId);
        return new SelectListDescriptor<Long>("getChildInstanceIdsOfProcessInstance", map, class1, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfChildInstancesOfProcessInstance(long processInstanceId) {
        Map<String, Object> parameters = Collections.singletonMap("processInstanceId", processInstanceId);
        return new SelectOneDescriptor<Long>("getNumberOfChildInstancesOfProcessInstance", parameters, SProcessInstance.class, Long.class);
    }

    public static SelectListDescriptor<SWaitingErrorEvent> getCaughtError(long relatedActivityInstanceId, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("relatedActivityInstanceId", relatedActivityInstanceId);
        return new SelectListDescriptor<SWaitingErrorEvent>("getCaughtErrorByRelatedActivityAndAnyErrorCode", parameters, SWaitingErrorEvent.class, queryOptions);
    }

    public static SelectListDescriptor<SWaitingErrorEvent> getCaughtError(long relatedActivityInstanceId, String errorCode, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("relatedActivityInstanceId", relatedActivityInstanceId);
        parameters.put("errorCode", errorCode);
        return new SelectListDescriptor<SWaitingErrorEvent>("getCaughtErrorByRelatedActivityAndErrorCode", parameters, SWaitingErrorEvent.class, queryOptions);
    }

    public static SelectListDescriptor<SWaitingSignalEvent> getListeningSignals(String signalName, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("signalName", signalName);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SWaitingSignalEvent>("getListeningSignals", parameters, SWaitingSignalEvent.class, queryOptions);
    }

    public static SelectListDescriptor<SWaitingEvent> getStartWaitingEvents(long processDefinitionId, QueryOptions queryOptions) {
        Map<String, Object> parameters = Collections.singletonMap("processDefinitionId", processDefinitionId);
        return new SelectListDescriptor<SWaitingEvent>("getStartWaitingEvents", parameters, SWaitingEvent.class, queryOptions);
    }

    public static SelectListDescriptor<SMessageEventCouple> getMessageEventCouples(int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.emptyMap();
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SMessageEventCouple>("getMessageEventCouples", parameters, SMessageEventCouple.class, queryOptions);
    }

    public static SelectOneDescriptor<SAActivityInstance> getArchivedActivityInstanceWithActivityIdAndStateId(long activityInstanceId, int stateId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("activityInstanceId", activityInstanceId);
        parameters.put("stateId", stateId);
        return new SelectOneDescriptor<SAActivityInstance>("getAActivityInstanceByActivityInstanceIdAndStateId", parameters, SAActivityInstance.class);
    }

    public static SelectOneDescriptor<SAActivityInstance> getMostRecentArchivedActivityInstance(long activityInstanceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("activityInstanceId", activityInstanceId);
        return new SelectOneDescriptor<SAActivityInstance>("getMostRecentArchivedActivityInstance", parameters, SAActivityInstance.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfArchivedTasksSupervisedBy(long supervisorId) {
        Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
        return new SelectOneDescriptor<Long>("getNumberOfArchivedTasksSupervisedBy", parameters, SUserTaskInstance.class, Long.class);
    }

    public static SelectListDescriptor<SHumanTaskInstance> searchAssignedTasksSupervisedBy(long supervisorId, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SHumanTaskInstance>("searchAssignedTasksSupervisedBy", parameters, SHumanTaskInstance.class, queryOptions);
    }

    public static SelectListDescriptor<SHumanTaskInstance> searchArchivedTasksSupervisedBy(long supervisorId, int fromIndex, int maxResults) {
        Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults);
        return new SelectListDescriptor<SHumanTaskInstance>("searchArchivedTasksSupervisedBy", parameters, SHumanTaskInstance.class, queryOptions);
    }

    public static SelectListDescriptor<Map<String, Long>> getNumbersOfAssignedOpenTasks(List<Long> userIds) {
        QueryOptions queryOptions = new QueryOptions(0, userIds.size());
        Map<String, Object> parameters = Collections.singletonMap("assigneeIds", userIds);
        return new SelectListDescriptor<Map<String, Long>>("getNumbersOfOpenTasksForUsers", parameters, SHumanTaskInstance.class, queryOptions);
    }

    public static SelectListDescriptor<Map<Long, Long>> getNumbersOfAssignedOverdueOpenTasks(List<Long> userIds) {
        QueryOptions queryOptions = new QueryOptions(0, userIds.size());
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("assigneeIds", userIds);
        parameters.put("currentTime", System.currentTimeMillis());
        return new SelectListDescriptor<Map<Long, Long>>("getNumbersOfAssignedOverdueTasksForUsers", parameters, SHumanTaskInstance.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfPendingOverdueOpenTasksForUser(Long userId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("userId", userId);
        parameters.put("currentTime", System.currentTimeMillis());
        return new SelectOneDescriptor<Long>("getNumberOfPendingOverdueTasksForUser", parameters, SHumanTaskInstance.class, Long.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfTokensOfProcessInstance(long processInstanceId) {
        return new SelectOneDescriptor<Long>("getNumberOfTokensOfProcessInstance", Collections.singletonMap("processInstanceId", processInstanceId), SToken.class, Long.class);
    }

    public static SelectListDescriptor<SToken> getTokensOfProcessInstance(long processInstanceId, QueryOptions queryOptions) {
        return new SelectListDescriptor<SToken>("getTokensOfProcessInstance", Collections.singletonMap("processInstanceId", processInstanceId), SToken.class, queryOptions);
    }

    public static SelectListDescriptor<SToken> getTokens(QueryOptions queryOptions) {
        return new SelectListDescriptor<SToken>("getTokens", Collections.<String, Object>emptyMap(), SToken.class, queryOptions);
    }

    public static SelectListDescriptor<SToken> getToken(long processInstanceId, long refId) {
        HashMap<String, Object> singletonMap = new HashMap<String, Object>(2);
        singletonMap.put("processInstanceId", processInstanceId);
        singletonMap.put("refId", refId);
        return new SelectListDescriptor<SToken>("getToken", singletonMap, SToken.class, new QueryOptions(0, 1));
    }

    public static SelectOneDescriptor<Long> getNumberOfToken(long processInstanceId, long refId) {
        HashMap<String, Object> singletonMap = new HashMap<String, Object>(2);
        singletonMap.put("processInstanceId", processInstanceId);
        singletonMap.put("refId", refId);
        return new SelectOneDescriptor<Long>("getNumberToken", singletonMap, SToken.class);
    }
}

