/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;

public class TransitionEvaluator {
    private final ExpressionResolverService expressionResolverService;

    public TransitionEvaluator(ExpressionResolverService expressionResolverService) {
        this.expressionResolverService = expressionResolverService;
    }

    protected List<STransitionDefinition> evaluateOutgoingTransitions(List<STransitionDefinition> outgoingTransitionDefinitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        if (!SStateCategory.NORMAL.equals((Object)flowNodeInstance.getStateCategory())) {
            return Collections.emptyList();
        }
        SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), sDefinition.getId());
        if (SFlowNodeType.GATEWAY.equals((Object)flowNodeInstance.getType())) {
            return this.evaluateOutgoingTransitionsForGateways(outgoingTransitionDefinitions, sDefinition, flowNodeInstance, sExpressionContext);
        }
        if (SFlowNodeType.BOUNDARY_EVENT.equals((Object)flowNodeInstance.getType())) {
            return new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions);
        }
        return this.evaluateOutgoingTransitionsForActivity(outgoingTransitionDefinitions, sDefinition, flowNodeInstance, sExpressionContext);
    }

    List<STransitionDefinition> evaluateOutgoingTransitionsForActivity(List<STransitionDefinition> outgoingTransitionDefinitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, SExpressionContext sExpressionContext) throws SBonitaException {
        if (outgoingTransitionDefinitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
            if (defaultTransition == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(defaultTransition);
        }
        return this.evaluateTransitionsForImplicitGateway(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
    }

    List<STransitionDefinition> evaluateOutgoingTransitionsForGateways(List<STransitionDefinition> outgoingTransitionDefinitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, SExpressionContext sExpressionContext) throws SBonitaException {
        List<STransitionDefinition> chosenTransitionDefinitions;
        SGatewayInstance gatewayInstance = (SGatewayInstance)flowNodeInstance;
        switch (gatewayInstance.getGatewayType()) {
            case EXCLUSIVE: {
                chosenTransitionDefinitions = this.evaluateTransitionsExclusively(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
                break;
            }
            case INCLUSIVE: {
                chosenTransitionDefinitions = this.evaluateTransitionsInclusively(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
                break;
            }
            case PARALLEL: {
                chosenTransitionDefinitions = this.evaluateTransitionsPalely(outgoingTransitionDefinitions);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported gateway type: " + (Object)((Object)gatewayInstance.getGatewayType()));
            }
        }
        return chosenTransitionDefinitions;
    }

    List<STransitionDefinition> evaluateTransitionsExclusively(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        boolean transitionFound = false;
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition != null && !condition.booleanValue()) continue;
            transitionFound = true;
            chosenTransitions.add(sTransitionDefinition);
            break;
        }
        if (!transitionFound) {
            STransitionDefinition defaultTransition = this.getDefaultTransitionIfExists(sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
            outgoingTransitionDefinitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    STransitionDefinition getDefaultTransitionIfExists(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        STransitionDefinition defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
        if (defaultTransition == null) {
            this.throwSActivityExecutionException(sDefinition, flowNodeInstance);
        }
        return defaultTransition;
    }

    private void throwSActivityExecutionException(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        SActivityExecutionException exception = new SActivityExecutionException("There is no default transition on " + flowNodeInstance.getName() + ", but no outgoing transition had a valid condition.");
        exception.setProcessDefinitionNameOnContext(sDefinition.getName());
        exception.setProcessDefinitionVersionOnContext(sDefinition.getVersion());
        exception.setProcessInstanceIdOnContext(flowNodeInstance.getParentProcessInstanceId());
        throw exception;
    }

    List<STransitionDefinition> evaluateTransitionsInclusively(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition != null && !condition.booleanValue()) continue;
            chosenTransitions.add(sTransitionDefinition);
        }
        if (chosenTransitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransitionIfExists(sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
            outgoingTransitionDefinitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    protected List<STransitionDefinition> evaluateTransitionsForImplicitGateway(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        int transitionNumber = outgoingTransitionDefinitions.size();
        ArrayList<STransitionDefinition> conditionalTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> conditionalFalseTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> normalTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition == null) {
                normalTransitions.add(sTransitionDefinition);
                continue;
            }
            if (condition.booleanValue()) {
                conditionalTransitions.add(sTransitionDefinition);
                continue;
            }
            conditionalFalseTransitions.add(sTransitionDefinition);
        }
        if (!normalTransitions.isEmpty()) {
            chosenTransitions.addAll(normalTransitions);
        }
        if (!conditionalTransitions.isEmpty()) {
            chosenTransitions.addAll(conditionalTransitions);
        } else if (!conditionalFalseTransitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransitionIfExists(sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    List<STransitionDefinition> evaluateTransitionsPalely(List<STransitionDefinition> outgoingTransitionDefinitions) {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            chosenTransitions.add(sTransitionDefinition);
        }
        return chosenTransitions;
    }

    protected STransitionDefinition getDefaultTransition(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        return flowNode.getDefaultTransition();
    }

    protected Boolean evaluateCondition(SProcessDefinition sDefinition, STransitionDefinition sTransitionDefinition, SExpressionContext contextDependency) throws SExpressionEvaluationException, SExpressionTypeUnknownException, SExpressionDependencyMissingException, SInvalidExpressionException {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        STransitionDefinition transition = processContainer.getTransition(sTransitionDefinition.getName());
        SExpression expression = transition.getCondition();
        if (expression == null) {
            return null;
        }
        if (!Boolean.class.getName().equals(expression.getReturnType())) {
            throw new SExpressionEvaluationException("Condition expression must return a boolean, on transition: " + sTransitionDefinition.getName(), expression.getName());
        }
        return (Boolean)this.expressionResolverService.evaluate(expression, contextDependency);
    }

    FlowNodeTransitionsWrapper buildTransitionsWrapper(SFlowNodeDefinition flowNode, SProcessDefinition sProcessDefinition, SFlowNodeInstance child) throws SBonitaException {
        FlowNodeTransitionsWrapper transitionsDescriptor = new FlowNodeTransitionsWrapper();
        if (flowNode == null) {
            transitionsDescriptor.setInputTransitionsSize(0);
            transitionsDescriptor.setAllOutgoingTransitionDefinitions(Collections.<STransitionDefinition>emptyList());
        } else {
            transitionsDescriptor.setInputTransitionsSize(flowNode.getIncomingTransitions().size());
            transitionsDescriptor.setAllOutgoingTransitionDefinitions(new ArrayList<STransitionDefinition>(flowNode.getOutgoingTransitions()));
        }
        transitionsDescriptor.setValidOutgoingTransitionDefinitions(this.evaluateOutgoingTransitions(transitionsDescriptor.getAllOutgoingTransitionDefinitions(), sProcessDefinition, child));
        return transitionsDescriptor;
    }
}

