/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.flowmerger;

import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SObjectReadException;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.execution.TokenProvider;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.flowmerger.TokenInfo;

public class FlowMerger {
    private final SFlowNodeDefinition sFlowNodeDefinition;
    private final FlowNodeTransitionsWrapper transitionsWrapper;
    private final TokenProvider tokenProvider;

    public FlowMerger(SFlowNodeDefinition sFlowNodeDefinition, FlowNodeTransitionsWrapper transitionsDescriptor, TokenProvider tokenProvider) {
        this.sFlowNodeDefinition = sFlowNodeDefinition;
        this.transitionsWrapper = transitionsDescriptor;
        this.tokenProvider = tokenProvider;
    }

    public boolean mustConsumeInputTokenOnTakingTransition() {
        return this.sFlowNodeDefinition != null && !this.sFlowNodeDefinition.isBoundaryEvent() && this.sFlowNodeDefinition.isParalleleOrInclusive() && !this.transitionsWrapper.isLastFlowNode() && this.transitionsWrapper.hasMultipleIncomingTransitions();
    }

    public boolean mustCreateTokenOnFinish() {
        if (this.sFlowNodeDefinition == null || this.sFlowNodeDefinition.isBoundaryEvent() || this.sFlowNodeDefinition.isExclusive() || this.transitionsWrapper.isLastFlowNode()) {
            return false;
        }
        return this.transitionsWrapper.hasMultipleOutgoingTransitions();
    }

    public boolean isImplicitEnd() {
        if (this.sFlowNodeDefinition == null) {
            return false;
        }
        return this.transitionsWrapper.isLastFlowNode();
    }

    public TokenInfo getOutputTokenInfo() throws SObjectReadException, SObjectNotFoundException, SObjectCreationException {
        return this.tokenProvider.getOutputTokenInfo();
    }
}

