/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.impl.APIAccessorImpl;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.connector.ConnectorAPIAccessorImpl;
import org.bonitasoft.engine.connector.EngineExecutionContext;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.ExpressionConstants;
import org.bonitasoft.engine.expression.ExpressionConstantsResolver;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class EngineConstantExpressionExecutorStrategy
implements ExpressionExecutorStrategy {
    private final ActivityInstanceService activityInstanceService;
    private final ProcessInstanceService processInstanceService;
    private final SessionAccessor sessionAccessor;
    private final SessionService sessionService;

    public EngineConstantExpressionExecutorStrategy(ActivityInstanceService activityInstanceService, ProcessInstanceService processInstanceService, SessionService sessionService, SessionAccessor sessionAccessor) {
        this.activityInstanceService = activityInstanceService;
        this.processInstanceService = processInstanceService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
    }

    @Override
    public Serializable evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        ExpressionConstants expressionConstant = ExpressionConstantsResolver.getExpressionConstantsFromName((String)expression.getContent());
        if (expressionConstant == null) {
            expressionConstant = ExpressionConstants.API_ACCESSOR;
            expressionConstant = ExpressionConstantsResolver.getExpressionConstantsFromName((String)expression.getContent());
        }
        String expressionName = expression.getName();
        if (expressionConstant == null) {
            throw new SExpressionEvaluationException(expression.getContent() + " is not a valid Engine-provided variable", expressionName);
        }
        try {
            switch (expressionConstant) {
                case API_ACCESSOR: {
                    return this.getApiAccessor();
                }
                case CONNECTOR_API_ACCESSOR: {
                    return this.getConnectorApiAccessor();
                }
                case ENGINE_EXECUTION_CONTEXT: 
                case ACTIVITY_INSTANCE_ID: 
                case PROCESS_INSTANCE_ID: 
                case ROOT_PROCESS_INSTANCE_ID: 
                case PROCESS_DEFINITION_ID: 
                case TASK_ASSIGNEE_ID: {
                    return this.getFromContextOrEngineExecutionContext(expressionConstant, context, containerState);
                }
                case LOGGED_USER_ID: {
                    return Long.valueOf(this.getLoggedUserFromSession());
                }
            }
            Object object = context.get(expressionConstant.getEngineConstantName());
            if (object == null) {
                throw new SExpressionEvaluationException("EngineConstantExpression not supported for: " + expressionConstant.getEngineConstantName(), expressionName);
            }
            return (Serializable)object;
        }
        catch (STenantIdNotSetException e) {
            throw new SExpressionEvaluationException((Throwable)e, expressionName);
        }
        catch (SSessionNotFoundException e) {
            throw new SExpressionEvaluationException((Throwable)e, expressionName);
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new SExpressionEvaluationException("Error retrieving process instance while building EngineExecutionContext as EngineConstantExpression", e, expressionName);
        }
        catch (SProcessInstanceReadException e) {
            throw new SExpressionEvaluationException("Error retrieving process instance while building EngineExecutionContext as EngineConstantExpression", e, expressionName);
        }
        catch (SFlowNodeReadException e) {
            throw new SExpressionEvaluationException("Error retrieving flow node instance while building EngineExecutionContext as EngineConstantExpression", e, expressionName);
        }
        catch (SFlowNodeNotFoundException e) {
            throw new SExpressionEvaluationException("Error retrieving flow node instance while building EngineExecutionContext as EngineConstantExpression", e, expressionName);
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new SExpressionEvaluationException("Error retrieving activity instance while building EngineExecutionContext as EngineConstantExpression", e, expressionName);
        }
        catch (SBonitaReadException e) {
            throw new SExpressionEvaluationException("Error while building EngineExecutionContext as EngineConstantExpression", e, expressionName);
        }
        catch (SBonitaException e) {
            throw new SExpressionEvaluationException((Throwable)e, expressionName);
        }
    }

    protected APIAccessor getApiAccessor() {
        return new APIAccessorImpl();
    }

    protected APIAccessor getConnectorApiAccessor() throws STenantIdNotSetException {
        long tenantId = this.sessionAccessor.getTenantId();
        return new ConnectorAPIAccessorImpl(tenantId);
    }

    private long getLoggedUserFromSession() throws SSessionNotFoundException {
        return this.sessionService.getLoggedUserFromSession(this.sessionAccessor);
    }

    private Serializable getFromContextOrEngineExecutionContext(ExpressionConstants expressionConstant, Map<String, Object> context, ContainerState containerState) throws SBonitaException {
        Object object = context.get(expressionConstant.getEngineConstantName());
        if (object == null) {
            EngineExecutionContext engineContext = (EngineExecutionContext)context.get(ExpressionConstants.ENGINE_EXECUTION_CONTEXT.getEngineConstantName());
            if (engineContext != null) {
                return engineContext.getExpressionConstant(expressionConstant);
            }
            return this.evaluate(expressionConstant, context, containerState);
        }
        return (Serializable)object;
    }

    private Serializable evaluate(ExpressionConstants expressionConstant, Map<String, Object> context, ContainerState containerState) throws SBonitaException {
        if (ExpressionConstants.ENGINE_EXECUTION_CONTEXT.equals((Object)expressionConstant)) {
            return this.createContext(context, containerState);
        }
        if (context.containsKey("containerType") && context.containsKey("containerId")) {
            String containerType = (String)context.get("containerType");
            long containerId = (Long)context.get("containerId");
            if (ExpressionConstants.PROCESS_DEFINITION_ID.equals((Object)expressionConstant)) {
                return (Serializable)context.get("processDefinitionId");
            }
            if (DataInstanceContainer.ACTIVITY_INSTANCE.toString().equals(containerType)) {
                return this.evaluateUsingActivityInstanceContainer(expressionConstant, context, containerId);
            }
            return this.evaluateUsingProcessInstanceContainer(expressionConstant, context, containerId);
        }
        return Integer.valueOf(-1);
    }

    private Serializable evaluateUsingProcessInstanceContainer(ExpressionConstants expressionConstant, Map<String, Object> context, long containerId) throws SProcessInstanceNotFoundException, SProcessInstanceReadException {
        if (ExpressionConstants.PROCESS_INSTANCE_ID.equals((Object)expressionConstant)) {
            return Long.valueOf(containerId);
        }
        if (ExpressionConstants.TASK_ASSIGNEE_ID.equals((Object)expressionConstant)) {
            return Integer.valueOf(-1);
        }
        this.fillDependenciesFromProcessInstance(context, containerId);
        return this.getNonNullLong(expressionConstant, context);
    }

    private Serializable evaluateUsingActivityInstanceContainer(ExpressionConstants expressionConstant, Map<String, Object> context, long containerId) throws SBonitaException {
        if (ExpressionConstants.ACTIVITY_INSTANCE_ID.equals((Object)expressionConstant)) {
            return Long.valueOf(containerId);
        }
        this.fillDependenciesFromFlowNodeInstance(context, containerId);
        return this.getNonNullLong(expressionConstant, context);
    }

    private Serializable getNonNullLong(ExpressionConstants expressionConstant, Map<String, Object> context) {
        Serializable serializable = (Serializable)context.get(expressionConstant.getEngineConstantName());
        return serializable == null ? Long.valueOf(-1L) : serializable;
    }

    private void fillDependenciesFromProcessInstance(Map<String, Object> context, long processInstanceId) throws SProcessInstanceNotFoundException, SProcessInstanceReadException {
        SProcessInstance processInstance = this.processInstanceService.getProcessInstance(processInstanceId);
        context.put(ExpressionConstants.PROCESS_INSTANCE_ID.getEngineConstantName(), processInstance.getId());
        context.put(ExpressionConstants.ROOT_PROCESS_INSTANCE_ID.getEngineConstantName(), processInstance.getRootProcessInstanceId());
    }

    void fillDependenciesFromFlowNodeInstance(Map<String, Object> context, long flowNodeInstanceId) throws SBonitaException {
        if (context.get("time") != null) {
            SAActivityInstance aActivityInstance = this.activityInstanceService.getMostRecentArchivedActivityInstance(flowNodeInstanceId);
            context.put(ExpressionConstants.PROCESS_INSTANCE_ID.getEngineConstantName(), aActivityInstance.getLogicalGroup(3));
            context.put(ExpressionConstants.ROOT_PROCESS_INSTANCE_ID.getEngineConstantName(), aActivityInstance.getLogicalGroup(1));
            if (this.isHumanTask(aActivityInstance)) {
                SAHumanTaskInstance saHumanTask = (SAHumanTaskInstance)aActivityInstance;
                context.put(ExpressionConstants.TASK_ASSIGNEE_ID.getEngineConstantName(), saHumanTask.getAssigneeId());
            }
        } else {
            SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
            context.put(ExpressionConstants.PROCESS_INSTANCE_ID.getEngineConstantName(), flowNodeInstance.getLogicalGroup(3));
            context.put(ExpressionConstants.ROOT_PROCESS_INSTANCE_ID.getEngineConstantName(), flowNodeInstance.getLogicalGroup(1));
            if (this.isHumanTask(flowNodeInstance)) {
                SHumanTaskInstance taskInstance = (SHumanTaskInstance)flowNodeInstance;
                context.put(ExpressionConstants.TASK_ASSIGNEE_ID.getEngineConstantName(), taskInstance.getAssigneeId());
            }
        }
    }

    private boolean isHumanTask(SAFlowNodeInstance aFlowNodeInstance) {
        return SFlowNodeType.USER_TASK.equals((Object)aFlowNodeInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)aFlowNodeInstance.getType());
    }

    private boolean isHumanTask(SFlowNodeInstance flowNodeInstance) {
        return SFlowNodeType.USER_TASK.equals((Object)flowNodeInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)flowNodeInstance.getType());
    }

    private Serializable createContext(Map<String, Object> context, ContainerState containerState) throws SProcessInstanceNotFoundException, SProcessInstanceReadException, SActivityInstanceNotFoundException, SBonitaReadException {
        EngineExecutionContext ctx = new EngineExecutionContext();
        if (context.containsKey("containerType") && context.containsKey("containerId")) {
            String containerType = (String)context.get("containerType");
            long containerId = (Long)context.get("containerId");
            if (ContainerState.ARCHIVED.equals((Object)containerState)) {
                if (DataInstanceContainer.ACTIVITY_INSTANCE.toString().equals(containerType)) {
                    this.updateContextFromArchivedActivityInstance(ctx, containerId);
                } else if (DataInstanceContainer.PROCESS_INSTANCE.toString().equals(containerType)) {
                    this.updateContextFromArchivedProcessInstance(ctx, containerId);
                }
            } else if (DataInstanceContainer.ACTIVITY_INSTANCE.toString().equals(containerType)) {
                this.updateContextFromActivityInstance(ctx, containerId);
            } else if (DataInstanceContainer.PROCESS_INSTANCE.toString().equals(containerType)) {
                this.updateContextFromProcessInstance(ctx, containerId);
            }
        }
        if (context.containsKey("processDefinitionId")) {
            ctx.setProcessDefinitionId(((Long)context.get("processDefinitionId")).longValue());
        }
        return ctx;
    }

    private void updateContextFromArchivedProcessInstance(EngineExecutionContext ctx, long processInstanceId) throws SBonitaReadException {
        SAProcessInstance processInstance = this.processInstanceService.getLastArchivedProcessInstance(processInstanceId);
        if (processInstance != null) {
            ctx.setProcessInstanceId(processInstance.getSourceObjectId());
            ctx.setRootProcessInstanceId(processInstance.getRootProcessInstanceId());
        }
    }

    private void updateContextFromArchivedActivityInstance(EngineExecutionContext ctx, long activityInstanceId) throws SBonitaReadException {
        SAActivityInstance activityInstance = this.activityInstanceService.getLastArchivedFlowNodeInstance(SAActivityInstance.class, activityInstanceId);
        if (activityInstance != null) {
            ctx.setActivityInstanceId(activityInstance.getSourceObjectId());
            ctx.setProcessInstanceId(activityInstance.getParentProcessInstanceId());
            ctx.setRootProcessInstanceId(activityInstance.getRootProcessInstanceId());
            if (this.isHumanTask(activityInstance)) {
                ctx.setTaskAssigneeId(((SAHumanTaskInstance)activityInstance).getAssigneeId());
            }
        }
    }

    private void updateContextFromProcessInstance(EngineExecutionContext ctx, long processInstanceId) throws SProcessInstanceNotFoundException, SProcessInstanceReadException {
        SProcessInstance processInstance = this.processInstanceService.getProcessInstance(processInstanceId);
        ctx.setProcessInstanceId(processInstance.getId());
        ctx.setRootProcessInstanceId(processInstance.getRootProcessInstanceId());
    }

    private void updateContextFromActivityInstance(EngineExecutionContext ctx, long activityInstanceId) throws SBonitaReadException, SActivityInstanceNotFoundException {
        ctx.setActivityInstanceId(activityInstanceId);
        SActivityInstance activityInstance = this.activityInstanceService.getActivityInstance(activityInstanceId);
        ctx.setProcessInstanceId(activityInstance.getParentProcessInstanceId());
        ctx.setRootProcessInstanceId(activityInstance.getRootProcessInstanceId());
        if (this.isHumanTask(activityInstance)) {
            ctx.setTaskAssigneeId(((SHumanTaskInstance)activityInstance).getAssigneeId());
        }
    }

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        if (ExpressionConstantsResolver.getExpressionConstantsFromName((String)expression.getContent()) == null) {
            throw new SInvalidExpressionException("Unable to get Engine Constant '" + expression.getContent() + "' in expression: " + expression, expression.getName());
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_ENGINE_CONSTANT;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (SExpression sExpression : expressions) {
            results.add(this.evaluate(sExpression, (Map)context, (Map)resolvedExpressions, containerState));
        }
        return results;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return true;
    }

    public SessionAccessor getSessionAccessor() {
        return this.sessionAccessor;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }
}

