/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler;

import java.util.Date;
import java.util.List;
import org.bonitasoft.engine.commons.PlatformLifecycleService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.scheduler.AbstractBonitaPlatformJobListener;
import org.bonitasoft.engine.scheduler.AbstractBonitaTenantJobListener;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.scheduler.trigger.Trigger;

public interface SchedulerService
extends PlatformLifecycleService {
    public static final String JOB_DESCRIPTOR = "JOB_DESCRIPTOR";
    public static final String JOB_PARAMETER = "JOB_PARAMETER";
    public static final String SCHEDULER_STARTED = "SCHEDULER_STARTED";
    public static final String SCHEDULER_STOPPED = "SCHEDULER_STOPPED";
    public static final String JOB_FAILED = "JOB_FAILED";

    public boolean isStarted() throws SSchedulerException;

    public boolean isStopped() throws SSchedulerException;

    public void schedule(SJobDescriptor var1, Trigger var2) throws SSchedulerException;

    public void schedule(SJobDescriptor var1, List<SJobParameter> var2, Trigger var3) throws SSchedulerException;

    public void executeAgain(long var1) throws SSchedulerException;

    public void executeAgain(long var1, List<SJobParameter> var3) throws SSchedulerException;

    public void executeNow(SJobDescriptor var1, List<SJobParameter> var2) throws SSchedulerException;

    public boolean delete(String var1) throws SSchedulerException;

    public void deleteJobs() throws SSchedulerException;

    public List<String> getJobs() throws SSchedulerException;

    public List<String> getAllJobs() throws SSchedulerException;

    public boolean isStillScheduled(SJobDescriptor var1) throws SSchedulerException;

    public void rescheduleErroneousTriggers() throws SSchedulerException;

    public void pauseJobs(long var1) throws SSchedulerException;

    public void resumeJobs(long var1) throws SSchedulerException;

    public Date rescheduleJob(String var1, String var2, Date var3) throws SSchedulerException;

    public void addJobListener(List<AbstractBonitaTenantJobListener> var1, String var2) throws SSchedulerException;

    public void addJobListener(List<AbstractBonitaPlatformJobListener> var1) throws SSchedulerException;

    public void initializeScheduler() throws SSchedulerException;

    @Override
    public void start() throws SBonitaException;

    @Override
    public void stop() throws SBonitaException;

    public boolean isExistingJob(String var1) throws SSchedulerException;
}

