/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.AbstractBonitaPlatformJobListener;
import org.bonitasoft.engine.scheduler.AbstractBonitaTenantJobListener;
import org.bonitasoft.engine.scheduler.SchedulerExecutor;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.impl.BonitaSchedulerFactory;
import org.bonitasoft.engine.scheduler.impl.ConcurrentQuartzJob;
import org.bonitasoft.engine.scheduler.impl.NonConcurrentQuartzJob;
import org.bonitasoft.engine.scheduler.impl.PlatformQuartzJobListener;
import org.bonitasoft.engine.scheduler.impl.SchedulerServiceImpl;
import org.bonitasoft.engine.scheduler.impl.TenantQuartzJobListener;
import org.bonitasoft.engine.scheduler.trigger.CronTrigger;
import org.bonitasoft.engine.scheduler.trigger.RepeatTrigger;
import org.bonitasoft.engine.scheduler.trigger.Trigger;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.transaction.TransactionState;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzSchedulerExecutor
implements SchedulerExecutor {
    private Scheduler scheduler;
    private final BonitaSchedulerFactory schedulerFactory;
    private final TransactionService transactionService;
    private final SessionAccessor sessionAccessor;
    private final TechnicalLoggerService logger;
    private final boolean useOptimization;
    private QuartzScheduler quartzScheduler;

    public QuartzSchedulerExecutor(BonitaSchedulerFactory schedulerFactory, TransactionService transactionService, SessionAccessor sessionAccessor, TechnicalLoggerService logger, boolean useOptimization) {
        this.transactionService = transactionService;
        this.sessionAccessor = sessionAccessor;
        this.logger = logger;
        this.useOptimization = useOptimization;
        this.schedulerFactory = schedulerFactory;
    }

    @Override
    public void setBOSSchedulerService(SchedulerServiceImpl schedulerService) {
        this.schedulerFactory.setBOSSchedulerService(schedulerService);
    }

    @Override
    public void schedule(long jobId, String groupName, String jobName, Trigger trigger, boolean disallowConcurrentExecution) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            JobDetail jobDetail = this.getJobDetail(jobId, groupName, jobName, disallowConcurrentExecution);
            JobKey jobKey = jobDetail.getKey();
            org.quartz.Trigger quartzTrigger = this.getQuartzTrigger(trigger, jobKey.getName(), jobKey.getGroup());
            this.scheduler.scheduleJob(jobDetail, quartzTrigger);
            if (this.useOptimization) {
                this.transactionService.registerBonitaSynchronization(new NotifyQuartzOfNewTrigger(trigger.getStartDate().getTime(), this.quartzScheduler));
            }
        }
        catch (Exception e) {
            throw new SSchedulerException(e);
        }
    }

    private JobDetail getJobDetail(long jobId, String groupName, String jobName, boolean disallowConcurrentExecution) {
        Class jobClass = null;
        jobClass = disallowConcurrentExecution ? NonConcurrentQuartzJob.class : ConcurrentQuartzJob.class;
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, groupName).build();
        jobDetail.getJobDataMap().put("tenantId", groupName);
        jobDetail.getJobDataMap().put("jobId", String.valueOf(jobId));
        jobDetail.getJobDataMap().put("jobName", jobName);
        return jobDetail;
    }

    @Override
    public void executeNow(long jobId, String groupName, String jobName, boolean disallowConcurrentExecution) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            JobDetail jobDetail = this.getJobDetail(jobId, groupName, jobName, disallowConcurrentExecution);
            this.scheduler.addJob(jobDetail, true);
            this.scheduler.triggerJob(jobDetail.getKey());
        }
        catch (Exception e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void executeAgain(long jobId, String groupName, String jobName, boolean disallowConcurrentExecution) throws SSchedulerException {
        try {
            JobDetail jobDetail2 = this.scheduler.getJobDetail(new JobKey(jobName, String.valueOf(groupName)));
            org.quartz.Trigger trigger = TriggerBuilder.newTrigger().withIdentity("OneShotTrigger" + UUID.randomUUID().getLeastSignificantBits(), String.valueOf(groupName)).forJob(jobName, String.valueOf(groupName)).startNow().build();
            if (jobDetail2 == null) {
                JobDetail jobDetail = this.getJobDetail(jobId, groupName, jobName, disallowConcurrentExecution);
                this.scheduler.scheduleJob(jobDetail, trigger);
            } else {
                this.scheduler.scheduleJob(trigger);
            }
            if (this.useOptimization) {
                this.transactionService.registerBonitaSynchronization(new NotifyQuartzOfNewTrigger(System.currentTimeMillis(), this.quartzScheduler));
            }
        }
        catch (Exception e) {
            throw new SSchedulerException(e);
        }
    }

    org.quartz.Trigger getQuartzTrigger(Trigger trigger, String jobName, String tenantId) {
        TriggerBuilder triggerBuilder;
        TriggerBuilder base = TriggerBuilder.newTrigger().forJob(jobName, tenantId).withIdentity(trigger.getName(), tenantId).startNow();
        if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronTrigger.getExpression());
            switch (cronTrigger.getMisfireHandlingPolicy()) {
                case NONE: {
                    cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                    break;
                }
                case ALL: {
                    cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case ONE: {
                    cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            triggerBuilder = base.withSchedule((ScheduleBuilder)cronScheduleBuilder).endAt(cronTrigger.getEndDate());
        } else if (trigger instanceof RepeatTrigger) {
            RepeatTrigger repeatTrigger = (RepeatTrigger)trigger;
            SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(repeatTrigger.getInterval()).withRepeatCount(repeatTrigger.getCount()).withMisfireHandlingInstructionIgnoreMisfires();
            triggerBuilder = base.withSchedule((ScheduleBuilder)scheduleBuilder).startAt(repeatTrigger.getStartDate());
            switch (repeatTrigger.getMisfireHandlingPolicy()) {
                case NONE: {
                    scheduleBuilder.withMisfireHandlingInstructionNextWithRemainingCount();
                    break;
                }
                case ALL: {
                    scheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case ONE: {
                    scheduleBuilder.withMisfireHandlingInstructionNowWithRemainingCount();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            triggerBuilder = base.startAt(trigger.getStartDate());
        }
        return triggerBuilder.withPriority(trigger.getPriority()).build();
    }

    @Override
    public boolean isStarted() throws SSchedulerException {
        try {
            return this.scheduler != null && this.scheduler.isStarted() && !this.scheduler.isShutdown();
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public boolean isShutdown() throws SSchedulerException {
        try {
            return this.scheduler != null && this.scheduler.isShutdown();
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void start() throws SSchedulerException {
        try {
            if (!this.isShutdown() && this.isStarted()) {
                throw new SSchedulerException("The scheduler is already started.");
            }
            this.scheduler.start();
            try {
                if (this.useOptimization) {
                    Field quartzSchedulerField = this.scheduler.getClass().getDeclaredField("sched");
                    quartzSchedulerField.setAccessible(true);
                    this.quartzScheduler = (QuartzScheduler)quartzSchedulerField.get(this.scheduler);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void shutdown() throws SSchedulerException {
        try {
            this.checkSchedulerState();
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    protected void checkSchedulerState() throws SSchedulerException {
        if (this.scheduler == null) {
            throw new SSchedulerException("The scheduler is not started");
        }
    }

    @Override
    public boolean delete(String jobName, String groupName) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)groupName);
            return this.scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public boolean isExistingJob(String jobName, String groupName) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)groupName);
            return this.scheduler.getJobDetail(jobKey) != null;
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void deleteJobs(String groupName) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            Set jobNames = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobNames) {
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public List<String> getJobs(String groupName) throws SSchedulerException {
        try {
            this.checkSchedulerState();
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            ArrayList<String> jobsNames = new ArrayList<String>(jobKeys.size());
            for (JobKey jobKey : jobKeys) {
                jobsNames.add(jobKey.getName());
            }
            return jobsNames;
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public List<String> getAllJobs() throws SSchedulerException {
        try {
            this.checkSchedulerState();
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupStartsWith((String)""));
            ArrayList<String> jobsNames = new ArrayList<String>(jobKeys.size());
            for (JobKey jobKey : jobKeys) {
                jobsNames.add(jobKey.getName());
            }
            return jobsNames;
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public boolean isStillScheduled(String groupName, String jobName) throws SSchedulerException {
        boolean stillScheduled = false;
        try {
            List triggers = this.scheduler.getTriggersOfJob(new JobKey(jobName, groupName));
            for (org.quartz.Trigger trigger : triggers) {
                if (trigger.getNextFireTime() == null) continue;
                stillScheduled = true;
            }
            return stillScheduled;
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void rescheduleErroneousTriggers() throws SSchedulerException {
        this.checkSchedulerState();
        try {
            List triggerGroupNames = this.scheduler.getTriggerGroupNames();
            for (String triggerGroupName : triggerGroupNames) {
                for (TriggerKey triggerKey : this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)triggerGroupName))) {
                    if (!Trigger.TriggerState.ERROR.equals((Object)this.scheduler.getTriggerState(triggerKey))) continue;
                    this.scheduler.pauseTrigger(triggerKey);
                    this.scheduler.resumeTrigger(triggerKey);
                }
            }
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void pauseJobs(String groupName) throws SSchedulerException {
        GroupMatcher groupEquals = GroupMatcher.triggerGroupEquals((String)groupName);
        try {
            this.scheduler.pauseTriggers(groupEquals);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException("Unable to put jobs of tenant " + groupName + " in pause", (Exception)((Object)e));
        }
    }

    @Override
    public void resumeJobs(String groupName) throws SSchedulerException {
        GroupMatcher groupEquals = GroupMatcher.triggerGroupEquals((String)groupName);
        try {
            this.scheduler.resumeTriggers(groupEquals);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException("Unable to put jobs of tenant " + groupName + " in pause", (Exception)((Object)e));
        }
    }

    @Override
    public Date rescheduleJob(String triggerName, String groupName, Date triggerStartTime) throws SSchedulerException {
        TriggerKey triggerKey = new TriggerKey(triggerName, groupName);
        try {
            org.quartz.Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
            org.quartz.Trigger newTrigger = oldTrigger.getTriggerBuilder().startAt(triggerStartTime).build();
            return this.scheduler.rescheduleJob(triggerKey, newTrigger);
        }
        catch (SchedulerException e) {
            throw new SSchedulerException("Can't get the trigger " + triggerKey, (Exception)((Object)e));
        }
    }

    @Override
    public void addJobListener(List<AbstractBonitaTenantJobListener> jobListeners, String groupName) throws SSchedulerException {
        try {
            this.scheduler.getListenerManager().addJobListener((JobListener)new TenantQuartzJobListener(jobListeners, groupName, this.sessionAccessor, this.transactionService, this.logger), (Matcher)GroupMatcher.groupEquals((String)groupName));
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void addJobListener(List<AbstractBonitaPlatformJobListener> jobListeners) throws SSchedulerException {
        try {
            ListenerManager listenerManager = this.scheduler.getListenerManager();
            listenerManager.addJobListener((JobListener)new PlatformQuartzJobListener(jobListeners));
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    @Override
    public void initializeScheduler() throws SSchedulerException {
        try {
            this.scheduler = this.schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            throw new SSchedulerException(e);
        }
    }

    private final class NotifyQuartzOfNewTrigger
    implements BonitaTransactionSynchronization {
        private final long time;
        private final QuartzScheduler quartzScheduler;

        public NotifyQuartzOfNewTrigger(long time, QuartzScheduler quartzScheduler) {
            this.time = time;
            this.quartzScheduler = quartzScheduler;
        }

        @Override
        public void beforeCommit() {
        }

        @Override
        public void afterCompletion(TransactionState txState) {
            if (TransactionState.COMMITTED.equals((Object)txState) && this.quartzScheduler != null) {
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(this.time);
            }
        }
    }
}

