/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service.impl;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.Logger;
import org.bonitasoft.engine.api.impl.APIAccessorImpl;
import org.bonitasoft.engine.api.permission.APICallContext;
import org.bonitasoft.engine.api.permission.PermissionRule;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SExecutionException;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.PermissionService;
import org.bonitasoft.engine.service.impl.ServerLoggerWrapper;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class PermissionServiceImpl
implements PermissionService {
    private final ClassLoaderService classLoaderService;
    private final TechnicalLoggerService logger;
    private final SessionAccessor sessionAccessor;
    private final SessionService sessionService;
    private final String scriptFolder;
    private final long tenantId;
    private GroovyClassLoader groovyClassLoader;

    public PermissionServiceImpl(ClassLoaderService classLoaderService, TechnicalLoggerService logger, SessionAccessor sessionAccessor, SessionService sessionService, String scriptFolder, long tenantId) {
        this.classLoaderService = classLoaderService;
        this.logger = logger;
        this.sessionAccessor = sessionAccessor;
        this.sessionService = sessionService;
        this.scriptFolder = scriptFolder;
        this.tenantId = tenantId;
    }

    @Override
    public boolean checkAPICallWithScript(String className, APICallContext context, boolean reload) throws SExecutionException, ClassNotFoundException {
        Class aClass;
        this.checkStarted();
        if (reload) {
            this.groovyClassLoader.clearCache();
            aClass = this.groovyClassLoader.loadClass(className, true, true, true);
        } else {
            aClass = Class.forName(className, true, (ClassLoader)this.groovyClassLoader);
        }
        if (!PermissionRule.class.isAssignableFrom(aClass)) {
            throw new SExecutionException("The class " + aClass.getName() + " does not implements org.bonitasoft.engine.api.permission.PermissionRule");
        }
        try {
            SSession session = this.sessionService.getSession(this.sessionAccessor.getSessionId());
            APISession apiSession = ModelConvertor.toAPISession(session, null);
            PermissionRule permissionRule = (PermissionRule)aClass.newInstance();
            return permissionRule.isAllowed(apiSession, context, (APIAccessor)this.createAPIAccessorImpl(), (Logger)new ServerLoggerWrapper(permissionRule.getClass(), this.logger));
        }
        catch (Throwable e) {
            throw new SExecutionException("The permission rule thrown an exception", e);
        }
    }

    protected APIAccessorImpl createAPIAccessorImpl() {
        return new APIAccessorImpl();
    }

    private void checkStarted() throws SExecutionException {
        if (this.groovyClassLoader == null) {
            throw new SExecutionException("The service is not started");
        }
    }

    @Override
    public void start() throws SBonitaException {
        this.groovyClassLoader = new GroovyClassLoader(this.classLoaderService.getLocalClassLoader(ScopeType.TENANT.name(), this.tenantId));
        this.groovyClassLoader.setShouldRecompile(Boolean.valueOf(true));
        File file = new File(this.scriptFolder);
        if (file.exists() && file.isDirectory()) {
            this.groovyClassLoader.addClasspath(file.getAbsolutePath());
        } else {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "The security script folder " + file + " does not exists or is a file, PermissionRules will be loaded only from the tenant classloader");
        }
    }

    @Override
    public void stop() {
        if (this.groovyClassLoader != null) {
            this.groovyClassLoader.clearCache();
            this.groovyClassLoader = null;
        }
    }

    @Override
    public void pause() {
        this.stop();
    }

    @Override
    public void resume() throws SBonitaException {
        this.start();
    }
}

