/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.xml.parse;

import java.util.List;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.xml.ElementBinding;
import org.bonitasoft.engine.xml.ElementBindingsFactory;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.ParserFactory;
import org.bonitasoft.engine.xml.XMLSchemaValidator;
import org.bonitasoft.engine.xml.XMLSchemaValidatorFactory;
import org.bonitasoft.engine.xml.parse.SAXParser;

public class SAXParserFactory
implements ParserFactory {
    private final XMLSchemaValidatorFactory validatorFactory;
    private final TechnicalLoggerService logger;

    public SAXParserFactory(XMLSchemaValidatorFactory validatorFactory, TechnicalLoggerService logger) {
        this.validatorFactory = validatorFactory;
        this.logger = logger;
    }

    @Override
    public Parser createParser(List<Class<? extends ElementBinding>> bindings) {
        XMLSchemaValidator validator = this.validatorFactory.createValidator();
        SAXParser saxParser = new SAXParser(validator, this.logger);
        saxParser.setBindings(bindings);
        return saxParser;
    }

    @Override
    public Parser createParser(ElementBindingsFactory bindingsFactory) {
        XMLSchemaValidator validator = this.validatorFactory.createValidator();
        SAXParser saxParser = new SAXParser(validator, this.logger);
        saxParser.setBindingsFactory(bindingsFactory);
        return saxParser;
    }
}

