/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.api.impl.resolver.ProcessDependencyResolver;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.bpm.process.impl.internal.ProblemImpl;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class ConnectorProcessDependencyResolver
implements ProcessDependencyResolver {
    @Override
    public boolean resolve(TenantServiceAccessor tenantAccessor, BusinessArchive businessArchive, SProcessDefinition sDefinition) throws ConnectorException {
        try {
            long tenantId = tenantAccessor.getTenantId();
            ConnectorService connectorService = tenantAccessor.getConnectorService();
            return connectorService.loadConnectors(sDefinition, tenantId) && this.checkAllConnectorsHaveImplementation(connectorService, sDefinition, tenantId).isEmpty();
        }
        catch (SConnectorException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private List<Problem> checkAllConnectorsHaveImplementation(ConnectorService connectorService, SProcessDefinition processDefinition, long tenantId) {
        Set<SFlowNodeDefinition> flowNodes;
        List<SConnectorDefinition> processConnectors = processDefinition.getProcessContainer().getConnectors();
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (processConnectors != null) {
            for (SConnectorDefinition sConnectorDefinition : processConnectors) {
                try {
                    connectorService.getConnectorImplementation(processDefinition.getId(), sConnectorDefinition.getConnectorId(), sConnectorDefinition.getVersion(), tenantId);
                }
                catch (SConnectorException e) {
                    ProblemImpl problem = new ProblemImpl(Problem.Level.ERROR, sConnectorDefinition.getName(), "connector", "The process connector '" + sConnectorDefinition.getName() + "' has no implementation");
                    problems.add((Problem)problem);
                }
            }
        }
        if ((flowNodes = processDefinition.getProcessContainer().getFlowNodes()) != null) {
            for (SFlowNodeDefinition sFlowNodeDefinition : flowNodes) {
                List<SConnectorDefinition> flowNodeConnectors = sFlowNodeDefinition.getConnectors();
                if (flowNodeConnectors == null) continue;
                for (SConnectorDefinition sConnectorDefinition : flowNodeConnectors) {
                    try {
                        connectorService.getConnectorImplementation(processDefinition.getId(), sConnectorDefinition.getConnectorId(), sConnectorDefinition.getVersion(), tenantId);
                    }
                    catch (SConnectorException e) {
                        ProblemImpl problem = new ProblemImpl(Problem.Level.ERROR, sConnectorDefinition.getName(), "connector", "The connector '" + sConnectorDefinition.getName() + "' of flow node '" + sFlowNodeDefinition.getName() + "' has no implementation");
                        problems.add((Problem)problem);
                    }
                }
            }
        }
        return problems;
    }

    @Override
    public List<Problem> checkResolution(TenantServiceAccessor tenantAccessor, SProcessDefinition processDefinition) {
        long tenantId = tenantAccessor.getTenantId();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        return this.checkAllConnectorsHaveImplementation(connectorService, processDefinition, tenantId);
    }
}

