/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.builder.SContactInfoBuilderFactory;

public class CreateUser
implements TransactionContentWithResult<SUser> {
    private final SUser sUser;
    private final IdentityService identityService;
    private final SContactInfo sPersonalData;
    private final SContactInfo sProfessionalData;
    private SUser user;

    public CreateUser(SUser sUser, SContactInfo sPersonalData, SContactInfo sProfessionalData, IdentityService identityService) {
        this.sUser = sUser;
        this.sPersonalData = sPersonalData;
        this.sProfessionalData = sProfessionalData;
        this.identityService = identityService;
    }

    @Override
    public void execute() throws SBonitaException {
        this.user = this.identityService.createUser(this.sUser);
        if (this.sPersonalData != null) {
            this.identityService.createUserContactInfo(BuilderFactory.get(SContactInfoBuilderFactory.class).createNewInstance(this.sPersonalData).setUserId(this.user.getId()).done());
        }
        if (this.sProfessionalData != null) {
            this.identityService.createUserContactInfo(BuilderFactory.get(SContactInfoBuilderFactory.class).createNewInstance(this.sProfessionalData).setUserId(this.user.getId()).done());
        }
    }

    @Override
    public SUser getResult() {
        return this.user;
    }
}

