/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.util.ArrayList;
import java.util.Collections;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAProcessInstanceBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstances;

public class GetNumberOfArchivedProcessInstance
implements TransactionContentWithResult<Long> {
    private final ProcessInstanceService processInstanceService;
    private final SearchEntitiesDescriptor searchEntitiesDescriptor;
    private long number;

    public GetNumberOfArchivedProcessInstance(ProcessInstanceService processInstanceService, SearchEntitiesDescriptor searchEntitiesDescriptor) {
        this.processInstanceService = processInstanceService;
        this.searchEntitiesDescriptor = searchEntitiesDescriptor;
    }

    @Override
    public void execute() throws SBonitaException {
        SearchArchivedProcessInstances searchProcessInstances = new SearchArchivedProcessInstances(this.processInstanceService, this.searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), null);
        SAProcessInstanceBuilderFactory saProcessInstanceBuilder = BuilderFactory.get(SAProcessInstanceBuilderFactory.class);
        ArrayList<FilterOption> filterOptions = new ArrayList<FilterOption>(2);
        filterOptions.add(new FilterOption(SAProcessInstance.class, saProcessInstanceBuilder.getStateIdKey(), ProcessInstanceState.COMPLETED.getId()));
        filterOptions.add(new FilterOption(SAProcessInstance.class, saProcessInstanceBuilder.getCallerIdKey(), -1));
        QueryOptions queryOptions = new QueryOptions(0, Integer.MAX_VALUE, Collections.<OrderByOption>emptyList(), filterOptions, null);
        this.number = searchProcessInstances.executeCount(queryOptions);
    }

    @Override
    public Long getResult() {
        return this.number;
    }
}

