/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.archive.impl;

import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.archive.ArchivingStrategy;
import org.bonitasoft.engine.archive.SArchiveDescriptor;
import org.bonitasoft.engine.archive.impl.BatchArchiveCallable;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.ArchivedPersistentObject;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;

public class ArchiveServiceImpl
implements ArchiveService {
    private final SArchiveDescriptor definitiveArchiveDescriptor;
    private final TransactionService transactionService;
    private final PersistenceService definitiveArchivePersistenceService;
    private final TechnicalLoggerService logger;
    private final ArchivingStrategy archivingStrategy;

    public ArchiveServiceImpl(SArchiveDescriptor definitiveArchiveDescriptor, PersistenceService definitiveArchivePersistenceService, TechnicalLoggerService logger, ArchivingStrategy archivingStrategy, TransactionService transactionService) {
        this.definitiveArchiveDescriptor = definitiveArchiveDescriptor;
        this.definitiveArchivePersistenceService = definitiveArchivePersistenceService;
        this.archivingStrategy = archivingStrategy;
        this.logger = logger;
        this.transactionService = transactionService;
    }

    @Override
    public void recordInsert(long time, ArchiveInsertRecord record) throws SRecorderException {
        if (this.isArchivable(record.getEntity().getPersistentObjectInterface())) {
            this.recordInserts(time, record);
        }
    }

    @Override
    public void recordInserts(long time, ArchiveInsertRecord ... records) throws SRecorderException {
        block3: {
            String methodName = "recordInserts";
            this.logBeforeMethod(TechnicalLogSeverity.TRACE, "recordInserts");
            if (records != null) {
                this.assignArchiveDate(time, records);
                BatchArchiveCallable callable = this.buildBatchArchiveCallable(records);
                try {
                    this.transactionService.registerBeforeCommitCallable(callable);
                }
                catch (STransactionNotFoundException e) {
                    if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) break block3;
                    this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to register the beforeCommitCallable to log queriable logs: transaction not found", e);
                }
            }
        }
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "recordInserts");
    }

    protected BatchArchiveCallable buildBatchArchiveCallable(ArchiveInsertRecord ... records) throws SRecorderException {
        return new BatchArchiveCallable(this.definitiveArchivePersistenceService, records);
    }

    private void assignArchiveDate(long time, ArchiveInsertRecord ... records) throws SRecorderException {
        for (ArchiveInsertRecord record : records) {
            if (record == null) continue;
            this.setArchiveDate(record.getEntity(), time);
        }
    }

    private void setArchiveDate(ArchivedPersistentObject entity, long time) throws SRecorderException {
        if (entity.getArchiveDate() <= 0L) {
            try {
                ClassReflector.invokeSetter(entity, "setArchiveDate", Long.TYPE, time);
            }
            catch (Exception e) {
                throw new SRecorderException(e);
            }
        }
    }

    @Override
    public void recordDelete(DeleteRecord record) throws SRecorderException {
        String methodName = "recordDelete";
        try {
            this.logBeforeMethod(TechnicalLogSeverity.TRACE, methodName);
            this.definitiveArchivePersistenceService.delete(record.getEntity());
            this.logAfterMethod(TechnicalLogSeverity.TRACE, methodName);
        }
        catch (SPersistenceException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, methodName, e);
            throw new SRecorderException(e);
        }
    }

    private void logOnExceptionMethod(TechnicalLogSeverity technicalLogSeverity, String methodName, Exception e) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, e));
        }
    }

    private void logAfterMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void logBeforeMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    @Override
    public SArchiveDescriptor getDefinitiveArchiveDescriptor() {
        return this.definitiveArchiveDescriptor;
    }

    @Override
    public boolean isArchivable(Class<? extends PersistentObject> sourceObjectClass) {
        return this.archivingStrategy.isArchivable(sourceObjectClass);
    }

    @Override
    public ReadPersistenceService getDefinitiveArchiveReadPersistenceService() {
        return this.definitiveArchivePersistenceService;
    }
}

