/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.io.Serializable;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.LeftOperandHandler;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class DataLeftOperandHandler
implements LeftOperandHandler {
    private final DataInstanceService dataInstanceService;

    public DataLeftOperandHandler(DataInstanceService dataInstanceService) {
        this.dataInstanceService = dataInstanceService;
    }

    @Override
    public String getType() {
        return "DATA";
    }

    @Override
    public Object update(SLeftOperand leftOperand, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        this.updateDataInstance(leftOperand, containerId, containerType, newValue);
        return newValue;
    }

    protected void update(SDataInstance sDataInstance, Object content) throws SDataInstanceException {
        EntityUpdateDescriptor updateDescriptor = new EntityUpdateDescriptor();
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        updateDescriptor.addField(fact.getValueKey(), content);
        this.dataInstanceService.updateDataInstance(sDataInstance, updateDescriptor);
    }

    private void checkReturnType(Object value, SDataInstance sDataInstance) throws SOperationExecutionException {
        Class<?> evaluatedReturnedType;
        Class<?> dataEffectiveType;
        Serializable dataValue;
        if (value != null && (dataValue = sDataInstance.getValue()) != null && !(dataEffectiveType = dataValue.getClass()).isAssignableFrom(evaluatedReturnedType = value.getClass()) && !dataEffectiveType.equals(evaluatedReturnedType)) {
            throw new SOperationExecutionException("Incompatible assignment operation type: Left operand " + dataEffectiveType + " is not compatible with right operand " + evaluatedReturnedType + " for expression with name '" + sDataInstance.getName() + "'");
        }
    }

    private void updateDataInstance(SLeftOperand leftOperand, long containerId, String containerType, Object expressionResult) throws SOperationExecutionException {
        String dataInstanceName = leftOperand.getName();
        try {
            SDataInstance sDataInstance = this.getDataInstance(dataInstanceName, containerId, containerType);
            this.checkReturnType(expressionResult, sDataInstance);
            this.update(sDataInstance, expressionResult);
        }
        catch (SDataInstanceException e) {
            throw new SOperationExecutionException(e);
        }
    }

    @Override
    public void delete(SLeftOperand leftOperand, long containerId, String containerType) throws SOperationExecutionException {
        throw new SOperationExecutionException("Deleting a data is not supported");
    }

    @Override
    public Object retrieve(SLeftOperand sLeftOperand, SExpressionContext expressionContext) throws SBonitaReadException {
        try {
            return this.getDataInstance(sLeftOperand.getName(), expressionContext.getContainerId(), expressionContext.getContainerType()).getValue();
        }
        catch (SDataInstanceException e) {
            throw new SBonitaReadException("Unable to retrieve the data", e);
        }
    }

    protected SDataInstance getDataInstance(String dataInstanceName, long containerId, String containerType) throws SDataInstanceException {
        return this.dataInstanceService.getDataInstance(dataInstanceName, containerId, containerType);
    }

    @Override
    public boolean supportBatchUpdate() {
        return true;
    }
}

