/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.util.Arrays;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectModificationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SObjectReadException;
import org.bonitasoft.engine.core.process.instance.api.TokenService;
import org.bonitasoft.engine.core.process.instance.model.SToken;
import org.bonitasoft.engine.core.process.instance.model.builder.STokenBuilderFactory;
import org.bonitasoft.engine.core.process.instance.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;

public class TokenServiceImpl
implements TokenService {
    private static final int BATCH_SIZE = 100;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceRead;
    private final EventService eventService;
    private final TechnicalLoggerService logger;
    private static final OrderByOption ORDER_BY_OPTION = new OrderByOption(SToken.class, "id", OrderByType.ASC);
    private static final QueryOptions QUERY_OPTIONS = new QueryOptions(0, 100, Arrays.asList(ORDER_BY_OPTION));

    public TokenServiceImpl(Recorder recorder, ReadPersistenceService persistenceRead, EventService eventService, TechnicalLoggerService logger) {
        this.recorder = recorder;
        this.persistenceRead = persistenceRead;
        this.eventService = eventService;
        this.logger = logger;
    }

    @Override
    public SToken createToken(Long processInstanceId, Long refId, Long parentRefId) throws SObjectCreationException {
        SToken token = BuilderFactory.get(STokenBuilderFactory.class).createNewInstance(processInstanceId, refId, parentRefId).done();
        InsertRecord insertRecord = new InsertRecord(token);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("ACTIVITY_INSTANCE_TOKEN_COUNT", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("ACTIVITY_INSTANCE_TOKEN_COUNT").setObject(token).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException sre) {
            throw new SObjectCreationException(sre);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Create token with id = <" + token.getId() + ">, process instance id = <" + processInstanceId + ">, refId = <" + refId + ">, parentRefId = <" + parentRefId + ">");
        }
        return token;
    }

    @Override
    public void createTokens(Long processInstanceId, Long refId, Long parentRefId, int numberOfToken) throws SObjectCreationException {
        if (numberOfToken > 0) {
            for (int i = 0; i < numberOfToken; ++i) {
                this.createToken(processInstanceId, refId, parentRefId);
            }
        }
    }

    @Override
    public void deleteTokens(Long processInstanceId, Long refId, int numberOfToken) throws SObjectModificationException, SObjectNotFoundException, SObjectReadException {
        if (numberOfToken > 0) {
            for (int i = 0; i < numberOfToken; ++i) {
                SToken token = this.getToken(processInstanceId, refId);
                this.deleteToken(token);
            }
        }
    }

    @Override
    public void deleteToken(SToken token) throws SObjectModificationException {
        try {
            DeleteRecord deleteRecord = new DeleteRecord(token);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("ACTIVITY_INSTANCE_TOKEN_COUNT", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("ACTIVITY_INSTANCE_TOKEN_COUNT").setObject(token).done();
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Delete token with id = <" + token.getId() + ">, process instance id = <" + token.getProcessInstanceId() + ">, refId = <" + token.getRefId() + ">, parentRefId = <" + token.getParentRefId() + ">");
            }
        }
        catch (SBonitaException e) {
            throw new SObjectModificationException(e);
        }
    }

    @Override
    public void deleteTokens(long processInstanceId) throws SObjectReadException, SObjectModificationException {
        List<SToken> tokens;
        do {
            tokens = this.getTokens(processInstanceId, QUERY_OPTIONS);
            for (SToken token : tokens) {
                this.deleteToken(token);
            }
        } while (tokens.size() == 100);
    }

    @Override
    public void deleteAllTokens() throws SObjectReadException, SObjectModificationException {
        List<SToken> tokens;
        do {
            tokens = this.getTokens(QUERY_OPTIONS);
            for (SToken token : tokens) {
                this.deleteToken(token);
            }
        } while (tokens.size() == 100);
    }

    public SToken getToken(long tokenId) throws SObjectNotFoundException, SObjectReadException {
        SToken instance;
        try {
            instance = this.persistenceRead.selectById(SelectDescriptorBuilder.getElementById(SToken.class, "ProcessInstanceTokenCount", tokenId));
        }
        catch (SBonitaReadException sbre) {
            throw new SObjectReadException(sbre);
        }
        if (instance == null) {
            throw new SObjectNotFoundException(tokenId);
        }
        return instance;
    }

    @Override
    public int getNumberOfToken(long processInstanceId) throws SObjectReadException {
        try {
            return this.persistenceRead.selectOne(SelectDescriptorBuilder.getNumberOfTokensOfProcessInstance(processInstanceId)).intValue();
        }
        catch (SBonitaReadException e) {
            throw new SObjectReadException(e);
        }
    }

    public List<SToken> getTokens(QueryOptions queryOptions) throws SObjectReadException {
        try {
            return this.persistenceRead.selectList(SelectDescriptorBuilder.getTokens(queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SObjectReadException(e);
        }
    }

    public List<SToken> getTokens(long processInstanceId, QueryOptions queryOptions) throws SObjectReadException {
        try {
            return this.persistenceRead.selectList(SelectDescriptorBuilder.getTokensOfProcessInstance(processInstanceId, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SObjectReadException(e);
        }
    }

    @Override
    public int getNumberOfToken(long processInstanceId, long refId) throws SObjectReadException {
        try {
            return this.persistenceRead.selectOne(SelectDescriptorBuilder.getNumberOfToken(processInstanceId, refId)).intValue();
        }
        catch (SBonitaReadException e) {
            throw new SObjectReadException(e);
        }
    }

    @Override
    public SToken getToken(long processInstanceId, long refId) throws SObjectNotFoundException, SObjectReadException {
        try {
            List<SToken> selectList = this.persistenceRead.selectList(SelectDescriptorBuilder.getToken(processInstanceId, refId));
            if (selectList.isEmpty()) {
                SObjectNotFoundException exception = new SObjectNotFoundException("No token found for reference = <" + refId + "> . The design may be invalid. Check that all branches are correctly merged.");
                exception.setProcessInstanceIdOnContext(processInstanceId);
                throw exception;
            }
            return selectList.get(0);
        }
        catch (SBonitaReadException e) {
            throw new SObjectReadException(e);
        }
    }
}

