/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity;

import java.util.List;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionAlreadyExistsException;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionCreationException;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionNotFoundException;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionReadException;
import org.bonitasoft.engine.identity.SCustomUserInfoValueNotFoundException;
import org.bonitasoft.engine.identity.SCustomUserInfoValueReadException;
import org.bonitasoft.engine.identity.SGroupCreationException;
import org.bonitasoft.engine.identity.SGroupDeletionException;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.SMembershipDeletionException;
import org.bonitasoft.engine.identity.SRoleDeletionException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserCreationException;
import org.bonitasoft.engine.identity.SUserDeletionException;
import org.bonitasoft.engine.identity.SUserMembershipCreationException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.SUserUpdateException;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.identity.model.SCustomUserInfoValue;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public interface IdentityService {
    public static final String GROUP = "GROUP";
    public static final String CUSTOM_USER_INFO_DEFINITION = "CUSTOM_USER_INFO_DEFINITION";
    public static final String CUSTOM_USER_INFO_VALUE = "CUSTOM_USER_INFO_VALUE";
    public static final String ROLE = "ROLE";
    public static final String USER = "USER";
    public static final String USER_CONTACT_INFO = "USER_CONTACT_INFO";
    public static final String USERMEMBERSHIP = "USERMEMBERSHIP";

    public SRole getRole(long var1) throws SRoleNotFoundException;

    public SRole getRoleByName(String var1) throws SRoleNotFoundException;

    public long getNumberOfRoles() throws SIdentityException;

    public List<SRole> getRoles(List<Long> var1) throws SRoleNotFoundException;

    public List<SRole> getRoles(int var1, int var2) throws SIdentityException;

    public List<SRole> getRoles(int var1, int var2, String var3, OrderByType var4) throws SIdentityException;

    public SGroup getGroupByPath(String var1) throws SGroupNotFoundException;

    public SGroup getGroup(long var1) throws SGroupNotFoundException;

    public long getNumberOfGroups() throws SIdentityException;

    public List<SGroup> getGroups(List<Long> var1) throws SGroupNotFoundException;

    public List<SGroup> getGroups(int var1, int var2) throws SIdentityException;

    public List<SGroup> getGroups(int var1, int var2, String var3, OrderByType var4) throws SIdentityException;

    public long getNumberOfGroupChildren(long var1) throws SIdentityException;

    public List<SGroup> getGroupChildren(long var1, int var3, int var4) throws SIdentityException;

    public List<SGroup> getGroupChildren(long var1, int var3, int var4, String var5, OrderByType var6) throws SIdentityException;

    public SUser getUser(long var1) throws SUserNotFoundException;

    public boolean chechCredentials(SUser var1, String var2);

    public SUser getUserByUserName(String var1) throws SUserNotFoundException;

    public long getNumberOfUsers() throws SIdentityException;

    public List<SUser> getUsers(List<Long> var1) throws SUserNotFoundException;

    public List<SUser> getUsersByUsername(List<String> var1) throws SIdentityException;

    public List<SUser> getUsers(int var1, int var2) throws SIdentityException;

    public List<SUser> getUsers(int var1, int var2, String var3, OrderByType var4) throws SIdentityException;

    public List<SUser> getUsersByManager(long var1, int var3, int var4) throws SIdentityException;

    public long getNumberOfUsersByRole(long var1) throws SIdentityException;

    public List<SUser> getUsersByRole(long var1, int var3, int var4) throws SIdentityException;

    public List<SUser> getUsersByRole(long var1, int var3, int var4, String var5, OrderByType var6) throws SIdentityException;

    public long getNumberOfUsersByGroup(long var1) throws SIdentityException;

    public List<SUser> getUsersByGroup(long var1, int var3, int var4) throws SIdentityException;

    public List<SUser> getUsersByGroup(long var1, int var3, int var4, String var5, OrderByType var6) throws SIdentityException;

    public List<SUserMembership> getUserMembershipsOfGroup(long var1, int var3, int var4) throws SIdentityException;

    public List<SUserMembership> getUserMembershipsOfRole(long var1, int var3, int var4) throws SIdentityException;

    public SUserMembership getUserMembership(long var1) throws SIdentityException;

    public SUserMembership getUserMembership(long var1, long var3, long var5) throws SIdentityException;

    public SUserMembership getLightUserMembership(long var1, long var3, long var5) throws SIdentityException;

    public List<SUserMembership> getUserMemberships(List<Long> var1) throws SIdentityException;

    public List<SUserMembership> getUserMemberships(int var1, int var2) throws SIdentityException;

    public List<SUserMembership> getUserMemberships(int var1, int var2, OrderByOption var3) throws SIdentityException;

    public SCustomUserInfoDefinition getCustomUserInfoDefinition(long var1) throws SIdentityException;

    public SCustomUserInfoValue getCustomUserInfoValue(long var1) throws SCustomUserInfoValueNotFoundException, SCustomUserInfoValueReadException;

    public SCustomUserInfoDefinition getCustomUserInfoDefinitionByName(String var1) throws SCustomUserInfoDefinitionNotFoundException, SCustomUserInfoDefinitionReadException;

    public boolean hasCustomUserInfoDefinition(String var1) throws SCustomUserInfoDefinitionReadException;

    public long getNumberOfCustomUserInfoDefinition() throws SIdentityException;

    public long getNumberOfCustomUserInfoValue(QueryOptions var1) throws SBonitaReadException;

    public List<SCustomUserInfoDefinition> getCustomUserInfoDefinitions(List<Long> var1) throws SIdentityException;

    public List<SCustomUserInfoValue> getCustomUserInfoValues(List<Long> var1) throws SIdentityException;

    public List<SCustomUserInfoDefinition> getCustomUserInfoDefinitions(int var1, int var2) throws SIdentityException;

    public List<Long> getUserIdsWithCustomUserInfo(String var1, String var2, boolean var3, int var4, int var5) throws SIdentityException;

    public List<SCustomUserInfoValue> searchCustomUserInfoValue(QueryOptions var1) throws SBonitaReadException;

    public List<SUserMembership> getUserMembershipsOfUser(long var1, int var3, int var4) throws SIdentityException;

    public List<SUserMembership> getUserMembershipsOfUser(long var1, int var3, int var4, String var5, OrderByType var6) throws SIdentityException;

    public List<SUserMembership> getUserMembershipsOfUser(long var1, int var3, int var4, OrderByOption var5) throws SIdentityException;

    public long getNumberOfUserMembershipsOfUser(long var1) throws SIdentityException;

    public long getNumberOfUserMemberships() throws SIdentityException;

    public SUser createUser(SUser var1) throws SUserCreationException;

    public void updateUser(SUser var1, EntityUpdateDescriptor var2) throws SUserUpdateException;

    @Deprecated
    public void updateUser(SUser var1, EntityUpdateDescriptor var2, boolean var3) throws SUserUpdateException;

    public SCustomUserInfoDefinition createCustomUserInfoDefinition(SCustomUserInfoDefinition var1) throws SCustomUserInfoDefinitionAlreadyExistsException, SCustomUserInfoDefinitionCreationException;

    public void updateCustomUserInfoDefinition(SCustomUserInfoDefinition var1, EntityUpdateDescriptor var2) throws SIdentityException;

    public SCustomUserInfoValue createCustomUserInfoValue(SCustomUserInfoValue var1) throws SIdentityException;

    public void updateCustomUserInfoValue(SCustomUserInfoValue var1, EntityUpdateDescriptor var2) throws SIdentityException;

    public void createRole(SRole var1) throws SIdentityException;

    public void updateRole(SRole var1, EntityUpdateDescriptor var2) throws SIdentityException;

    public void createGroup(SGroup var1) throws SGroupCreationException;

    public void updateGroup(SGroup var1, EntityUpdateDescriptor var2) throws SIdentityException;

    public void createUserMembership(SUserMembership var1) throws SUserMembershipCreationException;

    public void updateUserMembership(SUserMembership var1, EntityUpdateDescriptor var2) throws SIdentityException;

    public void deleteUser(SUser var1) throws SUserDeletionException;

    public void deleteUser(long var1) throws SUserDeletionException;

    public void deleteAllUsers() throws SUserDeletionException;

    public void deleteCustomUserInfoDefinition(SCustomUserInfoDefinition var1) throws SIdentityException;

    public void deleteCustomUserInfoDefinition(long var1) throws SIdentityException;

    public void deleteCustomUserInfoValue(SCustomUserInfoValue var1) throws SIdentityException;

    public void deleteCustomUserInfoValue(long var1) throws SIdentityException;

    public void deleteRole(SRole var1) throws SRoleDeletionException;

    public void deleteRole(long var1) throws SRoleNotFoundException, SRoleDeletionException;

    public void deleteAllRoles() throws SRoleDeletionException;

    public void deleteGroup(SGroup var1) throws SGroupDeletionException;

    public void deleteGroup(long var1) throws SGroupNotFoundException, SGroupDeletionException;

    public void deleteAllGroups() throws SGroupDeletionException;

    public void deleteUserMembership(SUserMembership var1) throws SMembershipDeletionException;

    public void deleteLightUserMembership(SUserMembership var1) throws SMembershipDeletionException;

    public void deleteUserMembership(long var1) throws SMembershipDeletionException;

    public void deleteAllUserMemberships() throws SMembershipDeletionException;

    public long getNumberOfUsers(QueryOptions var1) throws SBonitaReadException;

    public List<SUser> searchUsers(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfRoles(QueryOptions var1) throws SBonitaReadException;

    public List<SRole> searchRoles(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfGroups(QueryOptions var1) throws SBonitaReadException;

    public List<SGroup> searchGroups(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfUsersByMembership(long var1, long var3) throws SIdentityException;

    public SUserMembership getLightUserMembership(long var1) throws SIdentityException;

    public List<SUserMembership> getLightUserMemberships(int var1, int var2) throws SIdentityException;

    public List<Long> deleteChildrenGroup(long var1) throws SGroupDeletionException, SGroupNotFoundException;

    public SContactInfo getUserContactInfo(long var1, boolean var3) throws SIdentityException;

    public SContactInfo createUserContactInfo(SContactInfo var1) throws SUserCreationException;

    public void updateUserContactInfo(SContactInfo var1, EntityUpdateDescriptor var2) throws SIdentityException;

    @Deprecated
    public SUser createUserWithoutEncryptingPassword(SUser var1) throws SUserCreationException;
}

