/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.scheduler.StatelessJob;
import org.bonitasoft.engine.scheduler.impl.AbstractQuartzJob;
import org.bonitasoft.engine.scheduler.impl.JobWrapper;
import org.bonitasoft.engine.scheduler.model.SJobData;
import org.bonitasoft.engine.scheduler.model.impl.SJobDataImpl;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public abstract class AbstractQuartzJobListener
implements JobListener {
    protected Long getJobDescriptorId(JobDetail jobDetail) {
        return Long.valueOf((String)jobDetail.getJobDataMap().getWrappedMap().get("jobId"));
    }

    protected Long getTenantId(JobDetail jobDetail) {
        return Long.valueOf((String)jobDetail.getJobDataMap().getWrappedMap().get("tenantId"));
    }

    protected StatelessJob getBosJob(JobExecutionContext context) {
        Job instance = context.getJobInstance();
        if (instance != null && instance instanceof AbstractQuartzJob) {
            AbstractQuartzJob job = (AbstractQuartzJob)instance;
            return job.getBosJob();
        }
        return null;
    }

    protected List<SJobData> getJobDataValueAndType(JobDetail jobDetail) {
        Set entries = jobDetail.getJobDataMap().getWrappedMap().entrySet();
        ArrayList<SJobData> jobDatas = new ArrayList<SJobData>(entries.size());
        for (Map.Entry<String, Object> entry : entries) {
            jobDatas.add(new SJobDataImpl(entry));
        }
        return jobDatas;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getJobType(Job job) {
        Class<?> jobClass = job.getClass();
        if (!AbstractQuartzJob.class.isAssignableFrom(jobClass)) return jobClass.getName();
        StatelessJob bosJob = ((AbstractQuartzJob)job).getBosJob();
        if (bosJob == null) return "null";
        if (!(bosJob instanceof JobWrapper)) return bosJob.getClass().getName();
        return ((JobWrapper)bosJob).getStatelessJob().getClass().getName();
    }

    protected Map<String, Serializable> buildMapContext(JobExecutionContext context) {
        JobDetail jobDetail = context.getJobDetail();
        Trigger trigger = context.getTrigger();
        TriggerKey triggerKey = trigger.getKey();
        JobKey jobKey = jobDetail.getKey();
        HashMap<String, Serializable> mapContext = new HashMap<String, Serializable>();
        mapContext.put("bosJob", this.getBosJob(context));
        mapContext.put("jobDescriptorId", this.getJobDescriptorId(jobDetail));
        mapContext.put("tenantId", this.getTenantId(jobDetail));
        mapContext.put("jobType", (Serializable)((Object)this.getJobType(context.getJobInstance())));
        mapContext.put("jobName", (Serializable)((Object)jobKey.getName()));
        mapContext.put("jobGroup", (Serializable)((Object)jobKey.getGroup()));
        mapContext.put("triggerName", (Serializable)((Object)triggerKey.getName()));
        mapContext.put("triggerGroup", (Serializable)((Object)triggerKey.getGroup()));
        mapContext.put("triggerPreviousFireTime", trigger.getPreviousFireTime());
        mapContext.put("triggerNextFireTime", trigger.getNextFireTime());
        mapContext.put("refireCount", Integer.valueOf(context.getRefireCount()));
        mapContext.put("jobDatas", (Serializable)((Object)this.getJobDataValueAndType(jobDetail)));
        mapContext.put("jobResult", (Serializable)((Object)String.valueOf(context.getResult())));
        return mapContext;
    }
}

