/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.descriptor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.builder.SDocumentBuilderFactory;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.search.descriptor.FieldDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;

public class SearchDocumentDescriptor
extends SearchEntityDescriptor {
    public static final String DOCUMENT_PREFIX = "document.";
    private final Map<String, FieldDescriptor> searchEntityKeys;
    private final Map<Class<? extends PersistentObject>, Set<String>> documentAllFields;

    SearchDocumentDescriptor() {
        SDocumentBuilderFactory fact = BuilderFactory.get(SDocumentBuilderFactory.class);
        this.searchEntityKeys = new HashMap<String, FieldDescriptor>(9);
        this.searchEntityKeys.put("documentAuthor", new FieldDescriptor(SMappedDocument.class, DOCUMENT_PREFIX + fact.getAuthorKey()));
        this.searchEntityKeys.put("documentContentFileName", new FieldDescriptor(SMappedDocument.class, DOCUMENT_PREFIX + fact.getFileNameKey()));
        this.searchEntityKeys.put("documentContentMimeType", new FieldDescriptor(SMappedDocument.class, DOCUMENT_PREFIX + fact.getMimeTypeKey()));
        this.searchEntityKeys.put("documentCreationDate", new FieldDescriptor(SMappedDocument.class, DOCUMENT_PREFIX + fact.getCreationDateKey()));
        this.searchEntityKeys.put("documentHasContent", new FieldDescriptor(SMappedDocument.class, DOCUMENT_PREFIX + fact.getHasContentKey()));
        this.searchEntityKeys.put("documentName", new FieldDescriptor(SMappedDocument.class, fact.getNameKey()));
        this.searchEntityKeys.put("documentDescription", new FieldDescriptor(SMappedDocument.class, fact.getDescriptionKey()));
        this.searchEntityKeys.put("version", new FieldDescriptor(SMappedDocument.class, fact.getVersionKey()));
        this.searchEntityKeys.put("index", new FieldDescriptor(SMappedDocument.class, fact.getIndexKey()));
        this.searchEntityKeys.put("documentURL", new FieldDescriptor(SMappedDocument.class, DOCUMENT_PREFIX + fact.getURLKey()));
        this.searchEntityKeys.put("processinstanceid", new FieldDescriptor(SMappedDocument.class, "processInstanceId"));
        this.documentAllFields = new HashMap<Class<? extends PersistentObject>, Set<String>>(1);
        HashSet<String> documentFields = new HashSet<String>(8);
        documentFields.add(DOCUMENT_PREFIX + fact.getFileNameKey());
        documentFields.add(DOCUMENT_PREFIX + fact.getMimeTypeKey());
        documentFields.add(fact.getNameKey());
        documentFields.add(fact.getDescriptionKey());
        documentFields.add(DOCUMENT_PREFIX + fact.getURLKey());
        this.documentAllFields.put(SMappedDocument.class, documentFields);
    }

    @Override
    protected Map<String, FieldDescriptor> getEntityKeys() {
        return this.searchEntityKeys;
    }

    @Override
    protected Map<Class<? extends PersistentObject>, Set<String>> getAllFields() {
        return this.documentAllFields;
    }
}

