/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.supervisor;

import java.util.List;
import org.bonitasoft.engine.bpm.flownode.ArchivedActivityInstance;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;

public class SearchArchivedActivityInstanceSupervisedBy
extends AbstractSearchEntity<ArchivedActivityInstance, SAActivityInstance> {
    private final ActivityInstanceService activityInstanceService;
    private final FlowNodeStateManager flowNodeStateManager;
    private final Long supervisorId;

    public SearchArchivedActivityInstanceSupervisedBy(Long supervisorId, ActivityInstanceService activityInstanceService, FlowNodeStateManager flowNodeStateManager, SearchEntityDescriptor searchDescriptor, SearchOptions searchOptions) {
        super(searchDescriptor, searchOptions);
        this.supervisorId = supervisorId;
        this.activityInstanceService = activityInstanceService;
        this.flowNodeStateManager = flowNodeStateManager;
    }

    @Override
    public long executeCount(QueryOptions searchOptions) throws SBonitaReadException {
        return this.activityInstanceService.getNumberOfArchivedFlowNodeInstancesSupervisedBy(this.supervisorId, SAActivityInstance.class, searchOptions);
    }

    @Override
    public List<SAActivityInstance> executeSearch(QueryOptions searchOptions) throws SBonitaReadException {
        return this.activityInstanceService.searchArchivedFlowNodeInstancesSupervisedBy(this.supervisorId, SAActivityInstance.class, searchOptions);
    }

    @Override
    public List<ArchivedActivityInstance> convertToClientObjects(List<SAActivityInstance> serverObjects) {
        return ModelConvertor.toArchivedActivityInstances(serverObjects, this.flowNodeStateManager);
    }
}

