/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.supervisor.mapping.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisor;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorBuilderFactory;

public class SelectDescriptorBuilder {
    public static SelectByIdDescriptor<SProcessSupervisor> getSupervisor(long supervisorId) {
        return new SelectByIdDescriptor<SProcessSupervisor>("getSupervisorById", SProcessSupervisor.class, supervisorId);
    }

    public static SelectOneDescriptor<Long> getNumberOfSupervisors(long processDefId) {
        Map<String, Object> parameters = Collections.singletonMap("processDefId", processDefId);
        return new SelectOneDescriptor<Long>("getNumberOfSupervisorsOfProcessDef", parameters, SProcessSupervisor.class);
    }

    public static SelectOneDescriptor<SProcessSupervisor> getSupervisor(long processDefId, long userId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefId", processDefId);
        parameters.put("userId", userId);
        return new SelectOneDescriptor<SProcessSupervisor>("getSupervisor", parameters, SProcessSupervisor.class);
    }

    public static SelectListDescriptor<Long> getProcessDefIdsOfUser(long userId, int fromIndex, int maxResult, OrderByType orderByType) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        OrderByOption orderByOption = new OrderByOption(SProcessSupervisor.class, BuilderFactory.get(SProcessSupervisorBuilderFactory.class).getProcessDefIdKey(), orderByType);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResult, Collections.singletonList(orderByOption));
        return new SelectListDescriptor<Long>("getProcessDefIdsOfUser", parameters, SProcessSupervisor.class, queryOptions);
    }
}

