/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.impl.transaction.command.DeleteSCommand;
import org.bonitasoft.engine.api.impl.transaction.command.GetCommands;
import org.bonitasoft.engine.api.impl.transaction.dependency.AddSDependency;
import org.bonitasoft.engine.api.impl.transaction.dependency.DeleteSDependency;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.command.CommandCriterion;
import org.bonitasoft.engine.command.CommandDescriptor;
import org.bonitasoft.engine.command.CommandExecutionException;
import org.bonitasoft.engine.command.CommandNotFoundException;
import org.bonitasoft.engine.command.CommandParameterizationException;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.CommandUpdater;
import org.bonitasoft.engine.command.DependencyNotFoundException;
import org.bonitasoft.engine.command.SCommandDeletionException;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandNotFoundException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.SCommandUpdateException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.command.model.SCommandBuilderFactory;
import org.bonitasoft.engine.command.model.SCommandCriterion;
import org.bonitasoft.engine.command.model.SCommandUpdateBuilder;
import org.bonitasoft.engine.command.model.SCommandUpdateBuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyAlreadyExistsException;
import org.bonitasoft.engine.dependency.SDependencyNotFoundException;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.search.SearchCommands;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.UserTransactionService;

public class CommandAPIImpl
implements CommandAPI {
    protected static TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addDependency(String name, byte[] jar) throws AlreadyExistsException, CreationException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        DependencyService dependencyService = tenantAccessor.getDependencyService();
        AddSDependency addSDependency = new AddSDependency(dependencyService, name, jar, tenantAccessor.getTenantId(), ScopeType.TENANT);
        try {
            addSDependency.execute();
        }
        catch (SDependencyAlreadyExistsException e) {
            throw new AlreadyExistsException((Throwable)e);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void removeDependency(String name) throws DependencyNotFoundException, DeletionException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        DependencyService dependencyService = tenantAccessor.getDependencyService();
        DeleteSDependency deleteSDependency = new DeleteSDependency(dependencyService, name);
        try {
            deleteSDependency.execute();
        }
        catch (SDependencyNotFoundException sdnfe) {
            throw new DependencyNotFoundException((Throwable)sdnfe);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandDescriptor register(String name, String description, String implementation) throws AlreadyExistsException, CreationException {
        CommandDescriptor existingCommandDescriptor = null;
        try {
            existingCommandDescriptor = this.getCommand(name);
        }
        catch (CommandNotFoundException notFoundE) {
            if (existingCommandDescriptor != null) {
                throw new AlreadyExistsException("A command with name \"" + name + "\" already exists");
            }
        }
        finally {
            if (existingCommandDescriptor != null) {
                throw new AlreadyExistsException("A command with name \"" + name + "\" already exists");
            }
        }
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        CommandService commandService = tenantAccessor.getCommandService();
        SCommandBuilderFactory fact = BuilderFactory.get(SCommandBuilderFactory.class);
        SCommand sCommand = fact.createNewInstance(name, description, implementation).setSystem(false).done();
        try {
            commandService.create(sCommand);
            return ModelConvertor.toCommandDescriptor(sCommand);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    private TenantCommand fetchTenantCommand(SCommandFetcher commandFetcher, boolean transactionManagedManually) throws SCommandNotFoundException, SCommandParameterizationException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        try {
            SCommand sCommand = transactionManagedManually ? commandFetcher.fetchInTransaction(tenantAccessor.getUserTransactionService(), tenantAccessor.getCommandService()) : commandFetcher.fetch(tenantAccessor.getCommandService());
            String tenantCommandClassName = sCommand.getImplementation();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            return (TenantCommand)contextClassLoader.loadClass(tenantCommandClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new SCommandParameterizationException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new SCommandParameterizationException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new SCommandParameterizationException(iae);
        }
    }

    public Serializable execute(String commandName, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        return this.execute(new SCommandFetcherByName(commandName), parameters);
    }

    public Serializable execute(long commandId, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        return this.execute(new SCommandFetcherById(commandId), parameters);
    }

    private Serializable execute(SCommandFetcher commandFetcher, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        return this.executeCommand(commandFetcher, parameters, false);
    }

    @CustomTransactions
    public Serializable executeWithUserTransactions(String commandName, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        return this.executeWithUserTransactions(new SCommandFetcherByName(commandName), parameters);
    }

    @CustomTransactions
    public Serializable executeWithUserTransactions(long commandId, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        return this.executeWithUserTransactions(new SCommandFetcherById(commandId), parameters);
    }

    private Serializable executeWithUserTransactions(SCommandFetcher commandFetcher, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        return this.executeCommand(commandFetcher, parameters, true);
    }

    private Serializable executeCommand(SCommandFetcher commandFetcher, Map<String, Serializable> parameters, boolean transactionManagedManually) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        try {
            TenantCommand tenantCommand = this.fetchTenantCommand(commandFetcher, transactionManagedManually);
            return tenantCommand.execute(parameters, tenantAccessor);
        }
        catch (SCommandExecutionException scee) {
            throw new CommandExecutionException((Throwable)scee);
        }
        catch (SCommandParameterizationException scpe) {
            throw new CommandParameterizationException((Throwable)scpe);
        }
        catch (SCommandNotFoundException e) {
            throw new CommandNotFoundException((Throwable)e);
        }
    }

    public void unregister(long commandId) throws CommandNotFoundException, DeletionException {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        DeleteSCommand deleteCommand = new DeleteSCommand(commandService, commandId);
        this.unregister(deleteCommand);
    }

    public void unregister(String name) throws CommandNotFoundException, DeletionException {
        if (name == null) {
            throw new DeletionException("Command name can not be null!");
        }
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        DeleteSCommand deleteCommand = new DeleteSCommand(commandService, name);
        this.unregister(deleteCommand);
    }

    private void unregister(DeleteSCommand deleteCommand) throws CommandNotFoundException, DeletionException {
        try {
            deleteCommand.execute();
        }
        catch (SCommandNotFoundException scnfe) {
            throw new CommandNotFoundException((Throwable)scnfe);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public void unregisterAll() throws DeletionException {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            commandService.deleteAll();
        }
        catch (SCommandDeletionException sde) {
            throw new DeletionException((Throwable)sde);
        }
    }

    public CommandDescriptor get(long commandId) throws CommandNotFoundException {
        return this.getCommand(new SCommandFetcherById(commandId));
    }

    public CommandDescriptor getCommand(String commandName) throws CommandNotFoundException {
        return this.getCommand(new SCommandFetcherByName(commandName));
    }

    private CommandDescriptor getCommand(SCommandFetcher commandFetcher) throws CommandNotFoundException {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            SCommand sCommand = commandFetcher.fetch(commandService);
            return ModelConvertor.toCommandDescriptor(sCommand);
        }
        catch (SBonitaException e) {
            throw new CommandNotFoundException((Throwable)e);
        }
    }

    public List<CommandDescriptor> getAllCommands(int startIndex, int maxResults, CommandCriterion sort) {
        SCommandCriterion sCommandCriterion = null;
        sCommandCriterion = CommandCriterion.NAME_ASC.equals((Object)sort) ? SCommandCriterion.NAME_ASC : SCommandCriterion.NAME_DESC;
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            List<SCommand> commands = commandService.getAllCommands(startIndex, maxResults, sCommandCriterion);
            return ModelConvertor.toCommandDescriptors(commands);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void update(long commandId, CommandUpdater updateDescriptor) throws UpdateException {
        this.update(new SCommandFetcherById(commandId), updateDescriptor);
    }

    public void update(String commandName, CommandUpdater updateDescriptor) throws UpdateException {
        this.update(new SCommandFetcherByName(commandName), updateDescriptor);
    }

    private void update(SCommandFetcher commandFetcher, CommandUpdater updateDescriptor) throws UpdateException {
        if (updateDescriptor == null || updateDescriptor.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        SCommandUpdateBuilderFactory fact = BuilderFactory.get(SCommandUpdateBuilderFactory.class);
        SCommandUpdateBuilder commandUpdateBuilder = fact.createNewInstance();
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            EntityUpdateDescriptor changeDescriptor = this.getCommandUpdateDescriptor(updateDescriptor, commandUpdateBuilder);
            SCommand sCommand = commandFetcher.fetch(commandService);
            commandService.update(sCommand, changeDescriptor);
        }
        catch (SCommandNotFoundException scnfe) {
            throw new UpdateException((Throwable)scnfe);
        }
        catch (SCommandUpdateException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    private EntityUpdateDescriptor getCommandUpdateDescriptor(CommandUpdater updateDescriptor, SCommandUpdateBuilder commandUpdateBuilder) {
        Map fields = updateDescriptor.getFields();
        block4: for (Map.Entry field : fields.entrySet()) {
            String value = (String)field.getValue();
            switch ((CommandUpdater.CommandField)field.getKey()) {
                case NAME: {
                    commandUpdateBuilder.updateName(value);
                    continue block4;
                }
                case DESCRIPTION: {
                    commandUpdateBuilder.updateDescription(value);
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
        return commandUpdateBuilder.done();
    }

    public List<CommandDescriptor> getUserCommands(int startIndex, int maxResults, CommandCriterion sort) {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            GetCommands getCommands = new GetCommands(commandService, startIndex, maxResults, sort);
            getCommands.execute();
            return ModelConvertor.toCommandDescriptors((List<SCommand>)getCommands.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<CommandDescriptor> searchCommands(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        CommandService commandService = tenantAccessor.getCommandService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchCommands searchCommands = new SearchCommands(commandService, searchEntitiesDescriptor.getSearchCommandDescriptor(), searchOptions);
        try {
            searchCommands.execute();
            return searchCommands.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    private static class SCommandFetcherById
    extends SCommandFetcher {
        private final long commandId;

        public SCommandFetcherById(long commandId) {
            this.commandId = commandId;
        }

        @Override
        SCommand fetch(CommandService commandService) throws SCommandNotFoundException {
            return commandService.get(this.commandId);
        }
    }

    private static class SCommandFetcherByName
    extends SCommandFetcher {
        private final String commandName;

        public SCommandFetcherByName(String commandName) {
            this.commandName = commandName;
        }

        @Override
        SCommand fetch(CommandService commandService) throws SCommandNotFoundException {
            return commandService.get(this.commandName);
        }
    }

    private static abstract class SCommandFetcher {
        private SCommandFetcher() {
        }

        abstract SCommand fetch(CommandService var1) throws SCommandNotFoundException;

        SCommand fetchInTransaction(UserTransactionService userTransactionService, final CommandService commandService) throws SCommandNotFoundException {
            try {
                return userTransactionService.executeInTransaction(new Callable<SCommand>(){

                    @Override
                    public SCommand call() throws Exception {
                        return SCommandFetcher.this.fetch(commandService);
                    }
                });
            }
            catch (Exception e) {
                throw new SCommandNotFoundException(e);
            }
        }
    }
}

