/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.command.api.impl;

import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.SCommandAlreadyExistsException;
import org.bonitasoft.engine.command.SCommandCreationException;
import org.bonitasoft.engine.command.SCommandDeletionException;
import org.bonitasoft.engine.command.SCommandGettingException;
import org.bonitasoft.engine.command.SCommandNotFoundException;
import org.bonitasoft.engine.command.SCommandUpdateException;
import org.bonitasoft.engine.command.api.record.SelectDescriptorBuilder;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.command.model.SCommandBuilderFactory;
import org.bonitasoft.engine.command.model.SCommandCriterion;
import org.bonitasoft.engine.command.model.SCommandLogBuilder;
import org.bonitasoft.engine.command.model.SCommandLogBuilderFactory;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class CommandServiceImpl
implements CommandService {
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;

    public CommandServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
    }

    private SCommandLogBuilder getQueriableLog(ActionType actionType, String message) {
        SCommandLogBuilder logBuilder = BuilderFactory.get(SCommandLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public void create(SCommand command) throws SCommandAlreadyExistsException, SCommandCreationException {
        boolean isTraceEnable = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "create"));
        }
        try {
            this.get(command.getName());
            throw new SCommandAlreadyExistsException("Command '" + command.getName() + "' already exists");
        }
        catch (SCommandNotFoundException scmfe) {
            SCommandLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Creating a new command with name " + command.getName());
            InsertRecord insertRecord = new InsertRecord(command);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("COMMAND", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("COMMAND").setObject(command).done();
            }
            try {
                this.recorder.recordInsert(insertRecord, insertEvent);
                this.initiateLogBuilder(command.getId(), 1, logBuilder, "create");
                if (isTraceEnable) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "create"));
                }
            }
            catch (SRecorderException re) {
                if (isTraceEnable) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "create", re));
                }
                this.initiateLogBuilder(command.getId(), 0, logBuilder, "create");
                throw new SCommandCreationException(re);
            }
            return;
        }
    }

    @Override
    public void delete(String commandName) throws SCommandNotFoundException, SCommandDeletionException {
        SCommandLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting command with name " + commandName);
        boolean isTraceEnable = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "delete"));
        }
        SCommand command = this.get(commandName);
        DeleteRecord deleteRecord = new DeleteRecord(command);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("COMMAND", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("COMMAND").setObject(command).done();
        }
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            if (isTraceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "delete"));
            }
            this.initiateLogBuilder(command.getId(), 1, logBuilder, "delete");
        }
        catch (SRecorderException re) {
            if (isTraceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "delete", re));
            }
            this.initiateLogBuilder(command.getId(), 1, logBuilder, "delete");
            throw new SCommandDeletionException(re);
        }
    }

    @Override
    public void deleteAll() throws SCommandDeletionException {
        List<SCommand> commands;
        boolean isTraceEnable = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteAll"));
        }
        do {
            try {
                commands = this.getAllCommands(0, 100, SCommandCriterion.NAME_ASC);
                for (SCommand command : commands) {
                    this.delete(command.getName());
                }
            }
            catch (SCommandGettingException scge) {
                throw new SCommandDeletionException(scge);
            }
            catch (SCommandNotFoundException scnfe) {
                throw new SCommandDeletionException(scnfe);
            }
        } while (!commands.isEmpty());
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteAll"));
        }
    }

    @Override
    public SCommand get(String commandName) throws SCommandNotFoundException {
        boolean trace = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        try {
            SelectOneDescriptor<SCommand> descriptor;
            SCommand scommand;
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "get"));
            }
            if ((scommand = this.persistenceService.selectOne(descriptor = SelectDescriptorBuilder.getCommandByName(commandName))) == null) {
                throw new SCommandNotFoundException("command '" + commandName + "' does not exist");
            }
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "get"));
            }
            return scommand;
        }
        catch (SBonitaReadException e) {
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "get", e));
            }
            throw new SCommandNotFoundException("Cannot get command: " + commandName, e);
        }
    }

    @Override
    public List<SCommand> getAllCommands(int startIndex, int maxResults, SCommandCriterion sCommandCriterion) throws SCommandGettingException {
        boolean trace = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getAllCommands"));
        }
        String field = null;
        OrderByType orderByType = null;
        switch (sCommandCriterion) {
            case NAME_ASC: {
                orderByType = OrderByType.ASC;
                field = "name";
                break;
            }
            case NAME_DESC: {
                orderByType = OrderByType.DESC;
                field = "name";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        try {
            SelectListDescriptor<SCommand> descriptor = SelectDescriptorBuilder.getCommands(field, orderByType, startIndex, maxResults);
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getAllCommands"));
            }
            return this.persistenceService.selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getAllCommands", e));
            }
            throw new SCommandGettingException("can't get the commands", e);
        }
    }

    @Override
    public void update(SCommand command, EntityUpdateDescriptor updateDescriptor) throws SCommandUpdateException {
        boolean trace = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "update"));
        }
        SCommandLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Updating command with name " + command.getName());
        SCommandBuilderFactory fact = BuilderFactory.get(SCommandBuilderFactory.class);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)command, updateDescriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("COMMAND", EventActionType.UPDATED)) {
            SCommand oldCommand = fact.createNewInstance(command).done();
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("COMMAND").setObject(command).done();
            updateEvent.setOldObject(oldCommand);
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "update"));
            }
            this.initiateLogBuilder(command.getId(), 1, logBuilder, "update");
        }
        catch (SRecorderException re) {
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "update", re));
            }
            this.initiateLogBuilder(command.getId(), 0, logBuilder, "update");
            throw new SCommandUpdateException(re);
        }
    }

    @Override
    public List<SCommand> getUserCommands(int startIndex, int maxResults, SCommandCriterion sCommandCriterion) throws SCommandGettingException {
        boolean trace = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserCommands"));
        }
        String field = null;
        OrderByType orderByType = null;
        switch (sCommandCriterion) {
            case NAME_ASC: {
                orderByType = OrderByType.ASC;
                field = "name";
                break;
            }
            case NAME_DESC: {
                orderByType = OrderByType.DESC;
                field = "name";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        try {
            SelectListDescriptor<SCommand> descriptor = SelectDescriptorBuilder.getUserCommands(field, orderByType, startIndex, maxResults);
            List<SCommand> selectList = this.persistenceService.selectList(descriptor);
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserCommands"));
            }
            return selectList;
        }
        catch (SBonitaReadException e) {
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserCommands", e));
            }
            throw new SCommandGettingException("can't get the commands", e);
        }
    }

    @Override
    public SCommand get(long commandId) throws SCommandNotFoundException {
        SelectByIdDescriptor<SCommand> selectByIdDescriptor = SelectDescriptorBuilder.getCommandById(commandId);
        try {
            SCommand command = this.persistenceService.selectById(selectByIdDescriptor);
            if (command == null) {
                throw new SCommandNotFoundException(commandId + " does not refer to any command");
            }
            return command;
        }
        catch (SBonitaReadException bre) {
            throw new SCommandNotFoundException(bre);
        }
    }

    @Override
    public void delete(long commandId) throws SCommandNotFoundException, SCommandDeletionException {
        boolean isTraceEnable = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "delete"));
        }
        SCommandLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting command with id " + commandId);
        SCommand command = this.get(commandId);
        DeleteRecord deleteRecord = new DeleteRecord(command);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("COMMAND", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("COMMAND").setObject(command).done();
        }
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            if (isTraceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "delete"));
            }
            this.initiateLogBuilder(command.getId(), 1, logBuilder, "delete");
        }
        catch (SRecorderException re) {
            if (isTraceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "delete", re));
            }
            this.initiateLogBuilder(command.getId(), 0, logBuilder, "delete");
            throw new SCommandDeletionException(re);
        }
    }

    @Override
    public long getNumberOfCommands(QueryOptions options) throws SBonitaReadException {
        this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfCommands"));
        try {
            long number = this.persistenceService.getNumberOfEntities(SCommand.class, options, null);
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfCommands"));
            return number;
        }
        catch (SBonitaReadException bre) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfCommands", bre));
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SCommand> searchCommands(QueryOptions options) throws SBonitaReadException {
        boolean trace = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchCommands"));
        }
        try {
            List<SCommand> commands = this.persistenceService.searchEntity(SCommand.class, options, null);
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchCommands"));
            }
            return commands;
        }
        catch (SBonitaReadException bre) {
            if (trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchCommands", bre));
            }
            throw new SBonitaReadException(bre);
        }
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerClassName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerClassName, log);
        }
    }
}

