/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STaskVisibilityException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHiddenTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SLoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SPendingActivityMapping;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAHumanTaskInstance;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;

public interface ActivityInstanceService
extends FlowNodeInstanceService {
    public static final String ACTIVITYINSTANCE = "ACTIVITYINSTANCE";
    public static final String ARCHIVED_ACTIVITYINSTANCE = "ARCHIVED_ACTIVITYINSTANCE";
    public static final String PENDINGACTIVITYMAPPING = "PENDINGACTIVITYMAPPING";
    public static final String HIDDEN_TASK = "HIDDENTASK";

    public void createActivityInstance(SActivityInstance var1) throws SActivityCreationException;

    public void addPendingActivityMappings(SPendingActivityMapping var1) throws SActivityCreationException;

    public void deletePendingMappings(long var1) throws SActivityModificationException;

    public void deleteAllPendingMappings() throws SActivityModificationException;

    public SActivityInstance getActivityInstance(long var1) throws SActivityInstanceNotFoundException, SBonitaReadException;

    public SHumanTaskInstance getHumanTaskInstance(long var1) throws SActivityInstanceNotFoundException, SBonitaReadException;

    public List<SActivityInstance> getActivitiesWithStates(long var1, Set<Integer> var3, int var4, int var5, String var6, OrderByType var7) throws SBonitaReadException;

    public SAActivityInstance getMostRecentArchivedActivityInstance(long var1) throws SActivityInstanceNotFoundException, SBonitaReadException;

    public List<SHumanTaskInstance> getPendingTasks(long var1, Set<Long> var3, int var4, int var5, String var6, OrderByType var7) throws SBonitaReadException;

    public List<SHumanTaskInstance> getAssignedUserTasks(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public List<SAActivityInstance> getArchivedActivityInstances(long var1, QueryOptions var3) throws SBonitaReadException;

    public int getNumberOfOpenActivityInstances(long var1) throws SBonitaReadException;

    public List<SActivityInstance> getOpenActivityInstances(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public List<SActivityInstance> getActivityInstances(long var1, int var3, int var4) throws SBonitaReadException;

    public List<SActivityInstance> getChildrenOfAnActivity(long var1, int var3, int var4) throws SBonitaReadException;

    public void assignHumanTask(long var1, long var3) throws SFlowNodeNotFoundException, SFlowNodeReadException, SActivityModificationException;

    public void hideTasks(long var1, Long ... var3) throws SActivityInstanceNotFoundException, STaskVisibilityException, SBonitaReadException;

    public void unhideTasks(long var1, Long ... var3) throws STaskVisibilityException;

    public void unhideTask(long var1, long var3) throws STaskVisibilityException;

    public List<SHiddenTaskInstance> searchHiddenTasksForActivity(long var1, int var3, int var4) throws STaskVisibilityException;

    public long getNumberOfAssignedHumanTaskInstances(long var1) throws SBonitaReadException;

    public long getNumberOfAssignedTasksSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfArchivedHumanTasksSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchAssignedTasksSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SAHumanTaskInstance> searchArchivedHumanTasksSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public SAActivityInstance getArchivedActivityInstance(long var1, int var3) throws SActivityInstanceNotFoundException, SBonitaReadException;

    public List<SAHumanTaskInstance> searchArchivedTasks(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfArchivedTasks(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfAssignedTasksManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchAssignedTasksManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfArchivedTasksManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SAHumanTaskInstance> searchArchivedTasksManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchPendingTasksSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfPendingTasksSupervisedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfHumanTasks(QueryOptions var1) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchHumanTasks(QueryOptions var1) throws SBonitaReadException;

    public Map<Long, Long> getNumberOfOpenTasksForUsers(List<Long> var1) throws SBonitaReadException;

    public long searchNumberOfPendingTasksManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchPendingTasksManagedBy(long var1, QueryOptions var3) throws SBonitaReadException;

    public void incrementLoopCounter(SLoopActivityInstance var1) throws SActivityModificationException;

    public Map<Long, Long> getNumberOfOverdueOpenTasksForUsers(List<Long> var1) throws SBonitaReadException;

    public void setLoopMax(SLoopActivityInstance var1, Integer var2) throws SFlowNodeModificationException;

    public void setLoopCardinality(SFlowNodeInstance var1, int var2) throws SFlowNodeModificationException;

    public void addMultiInstanceNumberOfActiveActivities(SMultiInstanceActivityInstance var1, int var2) throws SFlowNodeModificationException;

    public void addMultiInstanceNumberOfTerminatedActivities(SMultiInstanceActivityInstance var1, int var2) throws SFlowNodeModificationException;

    public void addMultiInstanceNumberOfCompletedActivities(SMultiInstanceActivityInstance var1, int var2) throws SFlowNodeModificationException;

    public long getNumberOfActivityInstances(Class<? extends PersistentObject> var1, QueryOptions var2) throws SBonitaReadException;

    public List<SActivityInstance> searchActivityInstances(Class<? extends PersistentObject> var1, QueryOptions var2) throws SBonitaReadException;

    public long getNumberOfArchivedActivityInstances(Class<? extends PersistentObject> var1, QueryOptions var2) throws SBonitaReadException;

    public List<SAActivityInstance> searchArchivedActivityInstances(Class<? extends PersistentObject> var1, QueryOptions var2) throws SBonitaReadException;

    public void setTokenCount(SActivityInstance var1, int var2) throws SFlowNodeModificationException;

    public SHiddenTaskInstance getHiddenTask(long var1) throws STaskVisibilityException, SBonitaReadException;

    public SHiddenTaskInstance getHiddenTask(long var1, long var3) throws STaskVisibilityException;

    public void deleteHiddenTasksForActivity(long var1) throws STaskVisibilityException;

    public void deleteAllHiddenTasks() throws STaskVisibilityException;

    public long getNumberOfPendingHiddenTasks(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchPendingHiddenTasks(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfPendingTasksForUser(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchPendingTasksForUser(long var1, QueryOptions var3) throws SBonitaReadException;

    public boolean isTaskHidden(long var1, long var3) throws SBonitaReadException;

    public List<SPendingActivityMapping> getPendingMappings(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchPendingOrAssignedTasks(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfPendingOrAssignedTasks(long var1, QueryOptions var3) throws SBonitaReadException;

    public void deleteArchivedPendingMappings(long var1);

    public void setAbortedByBoundaryEvent(SActivityInstance var1, long var2) throws SActivityModificationException;

    public int getNumberOfActivityInstances(long var1) throws SBonitaReadException;

    public List<Long> getPossibleUserIdsOfPendingTasks(long var1, int var3, int var4) throws SBonitaReadException;

    public long getNumberOfUsersWhoCanExecutePendingHumanTaskDeploymentInfo(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SUser> searchUsersWhoCanExecutePendingHumanTaskDeploymentInfo(long var1, QueryOptions var3) throws SBonitaReadException;

    public long getNumberOfAssignedAndPendingHumanTasksFor(long var1, long var3, QueryOptions var5) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchAssignedAndPendingHumanTasksFor(long var1, long var3, QueryOptions var5) throws SBonitaReadException;

    public long getNumberOfAssignedAndPendingHumanTasks(long var1, QueryOptions var3) throws SBonitaReadException;

    public List<SHumanTaskInstance> searchAssignedAndPendingHumanTasks(long var1, QueryOptions var3) throws SBonitaReadException;

    public void deleteArchivedFlowNodeInstances(long var1) throws SFlowNodeDeletionException;

    public QueryOptions buildQueryOptionsForSubActivitiesInNormalStateAndNotTerminal(long var1, int var3);
}

