/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.model.archive.impl;

import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.impl.SAActivityInstanceImpl;
import org.bonitasoft.engine.persistence.PersistentObject;

public class SAMultiInstanceActivityInstanceImpl
extends SAActivityInstanceImpl
implements SAMultiInstanceActivityInstance {
    private static final long serialVersionUID = -2683110111754584325L;
    private boolean sequential;
    private String loopDataInputRef;
    private String loopDataOutputRef;
    private String dataInputItemRef;
    private String dataOutputItemRef;
    private int numberOfActiveInstances;
    private int numberOfCompletedInstances;
    private int numberOfTerminatedInstances;
    private int loopCardinality;

    public SAMultiInstanceActivityInstanceImpl() {
    }

    public SAMultiInstanceActivityInstanceImpl(SMultiInstanceActivityInstance activityInstance) {
        super(activityInstance);
        this.sequential = activityInstance.isSequential();
        this.loopDataInputRef = activityInstance.getLoopDataInputRef();
        this.loopDataOutputRef = activityInstance.getLoopDataOutputRef();
        this.dataInputItemRef = activityInstance.getDataInputItemRef();
        this.dataOutputItemRef = activityInstance.getDataOutputItemRef();
        this.numberOfActiveInstances = activityInstance.getNumberOfActiveInstances();
        this.numberOfCompletedInstances = activityInstance.getNumberOfCompletedInstances();
        this.numberOfTerminatedInstances = activityInstance.getNumberOfTerminatedInstances();
        this.loopCardinality = activityInstance.getLoopCardinality();
    }

    @Override
    public SFlowNodeType getType() {
        return SFlowNodeType.MULTI_INSTANCE_ACTIVITY;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public void setLoopDataInputRef(String loopDataInputRef) {
        this.loopDataInputRef = loopDataInputRef;
    }

    public void setLoopDataOutputRef(String loopDataOutputRef) {
        this.loopDataOutputRef = loopDataOutputRef;
    }

    public void setDataInputItemRef(String dataInputItemRef) {
        this.dataInputItemRef = dataInputItemRef;
    }

    public void setDataOutputItemRef(String dataOutputItemRef) {
        this.dataOutputItemRef = dataOutputItemRef;
    }

    public void setNumberOfActiveInstances(int numberOfActiveInstances) {
        this.numberOfActiveInstances = numberOfActiveInstances;
    }

    public void setNumberOfCompletedInstances(int numberOfCompletedInstances) {
        this.numberOfCompletedInstances = numberOfCompletedInstances;
    }

    public void setNumberOfTerminatedInstances(int numberOfTerminatedInstances) {
        this.numberOfTerminatedInstances = numberOfTerminatedInstances;
    }

    public void setLoopCardinality(int loopCardinality) {
        this.loopCardinality = loopCardinality;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public String getLoopDataInputRef() {
        return this.loopDataInputRef;
    }

    @Override
    public String getLoopDataOutputRef() {
        return this.loopDataOutputRef;
    }

    @Override
    public String getDataInputItemRef() {
        return this.dataInputItemRef;
    }

    @Override
    public String getDataOutputItemRef() {
        return this.dataOutputItemRef;
    }

    @Override
    public int getNumberOfInstances() {
        return this.numberOfActiveInstances + this.numberOfCompletedInstances + this.numberOfTerminatedInstances;
    }

    @Override
    public int getNumberOfActiveInstances() {
        return this.numberOfActiveInstances;
    }

    @Override
    public int getNumberOfCompletedInstances() {
        return this.numberOfCompletedInstances;
    }

    @Override
    public int getNumberOfTerminatedInstances() {
        return this.numberOfTerminatedInstances;
    }

    @Override
    public int getLoopCardinality() {
        return this.loopCardinality;
    }

    @Override
    public String getKind() {
        return "multi";
    }

    @Override
    public Class<? extends PersistentObject> getPersistentObjectInterface() {
        return SMultiInstanceActivityInstance.class;
    }

    @Override
    public String getDiscriminator() {
        return SAMultiInstanceActivityInstance.class.getName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataInputItemRef == null ? 0 : this.dataInputItemRef.hashCode());
        result = 31 * result + (this.dataOutputItemRef == null ? 0 : this.dataOutputItemRef.hashCode());
        result = 31 * result + this.loopCardinality;
        result = 31 * result + (this.loopDataInputRef == null ? 0 : this.loopDataInputRef.hashCode());
        result = 31 * result + (this.loopDataOutputRef == null ? 0 : this.loopDataOutputRef.hashCode());
        result = 31 * result + this.numberOfActiveInstances;
        result = 31 * result + this.numberOfCompletedInstances;
        result = 31 * result + this.numberOfTerminatedInstances;
        result = 31 * result + (this.sequential ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAMultiInstanceActivityInstanceImpl other = (SAMultiInstanceActivityInstanceImpl)obj;
        if (this.dataInputItemRef == null ? other.dataInputItemRef != null : !this.dataInputItemRef.equals(other.dataInputItemRef)) {
            return false;
        }
        if (this.dataOutputItemRef == null ? other.dataOutputItemRef != null : !this.dataOutputItemRef.equals(other.dataOutputItemRef)) {
            return false;
        }
        if (this.loopCardinality != other.loopCardinality) {
            return false;
        }
        if (this.loopDataInputRef == null ? other.loopDataInputRef != null : !this.loopDataInputRef.equals(other.loopDataInputRef)) {
            return false;
        }
        if (this.loopDataOutputRef == null ? other.loopDataOutputRef != null : !this.loopDataOutputRef.equals(other.loopDataOutputRef)) {
            return false;
        }
        if (this.numberOfActiveInstances != other.numberOfActiveInstances) {
            return false;
        }
        if (this.numberOfCompletedInstances != other.numberOfCompletedInstances) {
            return false;
        }
        if (this.numberOfTerminatedInstances != other.numberOfTerminatedInstances) {
            return false;
        }
        return this.sequential == other.sequential;
    }

    @Override
    public String toString() {
        return "SAMultiInstanceActivityInstanceImpl [sequential=" + this.sequential + ", loopDataInputRef=" + this.loopDataInputRef + ", loopDataOutputRef=" + this.loopDataOutputRef + ", dataInputItemRef=" + this.dataInputItemRef + ", dataOutputItemRef=" + this.dataOutputItemRef + ", numberOfActiveInstances=" + this.numberOfActiveInstances + ", numberOfCompletedInstances=" + this.numberOfCompletedInstances + ", numberOfTerminatedInstances=" + this.numberOfTerminatedInstances + ", loopCardinality=" + this.loopCardinality + ", isAborting()=" + this.isAborting() + ", getName()=" + this.getName() + ", getTenantId()=" + this.getTenantId() + ", getId()=" + this.getId() + ", getArchiveDate()=" + this.getArchiveDate() + ", getSourceObjectId()=" + this.getSourceObjectId() + "]";
    }
}

