/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.Map;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.SIllegalStateTransition;

public class NormalStateTransitionsManager {
    protected final Map<Integer, FlowNodeState> stateTransitions;
    private final SFlowNodeInstance flowNodeInstance;

    public NormalStateTransitionsManager(Map<Integer, FlowNodeState> stateTransitions, SFlowNodeInstance flowNodeInstance) {
        this.stateTransitions = stateTransitions;
        this.flowNodeInstance = flowNodeInstance;
    }

    public FlowNodeState getNextState(FlowNodeState currentState) throws SIllegalStateTransition {
        FlowNodeState nextState = this.getNextStateFromMap(currentState);
        if (nextState == null) {
            throw new SIllegalStateTransition(this.getMessage(currentState));
        }
        return nextState;
    }

    private String getMessage(FlowNodeState currentState) {
        StringBuilder stb = new StringBuilder();
        stb.append("no state found after ");
        stb.append(currentState.getClass().getName());
        stb.append(" for flow node of type ");
        stb.append(this.flowNodeInstance.getClass().getName());
        stb.append(" in state category ");
        stb.append((Object)this.flowNodeInstance.getStateCategory());
        stb.append(". Flow node instance id = ");
        stb.append(this.flowNodeInstance.getId());
        return stb.toString();
    }

    protected FlowNodeState getNextStateFromMap(FlowNodeState currentState) {
        return this.stateTransitions.get(currentState.getId());
    }
}

