/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.Map;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.impl.AbstractGroovyScriptExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.model.SExpression;

public class GroovyScriptExpressionExecutorStrategy
extends AbstractGroovyScriptExpressionExecutorStrategy {
    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        String expressionContent = expression.getContent();
        ClassLoader scriptClassLoader = Thread.currentThread().getContextClassLoader();
        String expressionName = expression.getName();
        try {
            GroovyShell shell = new GroovyShell(scriptClassLoader);
            Script script = shell.parse(expressionContent);
            Binding binding = new Binding(context);
            script.setBinding(binding);
            return script.evaluate(expressionContent);
        }
        catch (MissingPropertyException e) {
            String property = e.getProperty();
            StringBuilder builder = new StringBuilder("Expression ");
            builder.append(expressionName).append(" with content: ").append(expressionContent).append(" depends on ").append(property).append(" is neither defined in the script nor in dependencies");
            throw new SExpressionEvaluationException(builder.toString(), e, expressionName);
        }
        catch (GroovyRuntimeException e) {
            throw new SExpressionEvaluationException((Throwable)e, expressionName);
        }
        catch (Exception e) {
            throw new SExpressionEvaluationException("Script throws an exception" + expression, e, expressionName);
        }
    }
}

