/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl.condition;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.SExpression;

public class LogicalComplementExecutor {
    public Boolean evaluate(Map<Integer, Object> resolvedExpressions, SExpression expression) throws SExpressionEvaluationException {
        this.validate(expression);
        List<SExpression> dependencies = expression.getDependencies();
        Boolean sourceValue = (Boolean)resolvedExpressions.get(dependencies.get(0).getDiscriminant());
        return sourceValue != null ? Boolean.valueOf(sourceValue == false) : null;
    }

    private void validate(SExpression expression) throws SExpressionEvaluationException {
        List<SExpression> dependencies = expression.getDependencies();
        if (dependencies.size() != 1) {
            throw new SExpressionEvaluationException("The expression '!' must have exactly 1 dependency.", expression.getName());
        }
        if (!Boolean.class.getName().equals(dependencies.get(0).getReturnType())) {
            StringBuilder stb = new StringBuilder();
            stb.append("The dependency of expression '");
            stb.append("!");
            stb.append("' must have the return type ");
            stb.append(Boolean.class.getName());
            stb.append(", but ");
            stb.append(dependencies.get(0).getReturnType());
            stb.append(" was found.");
            throw new SExpressionEvaluationException(stb.toString(), expression.getName());
        }
    }
}

