/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.process;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public abstract class UpdateVariableValuesThroughOperations
extends TenantCommand {
    protected static final String OPERATIONS_LIST_KEY = "OPERATIONS_LIST_KEY";
    protected static final String OPERATIONS_INPUT_KEY = "OPERATIONS_INPUT_KEY";
    protected static final String CURRENT_VARIABLE_VALUES_MAP_KEY = "CURRENT_VARIABLE_VALUES_MAP_KEY";

    protected void updateVariablesThroughOperations(List<Operation> operations, Map<String, Serializable> operationsInputValues, Map<String, Serializable> currentVariableValues, long containerInstanceId) throws SBonitaException {
        ClassLoaderService classLoaderService = this.getServiceAccessor().getClassLoaderService();
        UpdateVariableValues tc = new UpdateVariableValues(operations, operationsInputValues, currentVariableValues, containerInstanceId, classLoaderService);
        tc.execute();
    }

    protected abstract void executeOperation(Operation var1, Map<String, Serializable> var2, Map<String, Serializable> var3, long var4) throws SBonitaException;

    public abstract long getProcessDefinitionId(long var1) throws SBonitaException;

    public abstract TenantServiceAccessor getServiceAccessor();

    class UpdateVariableValues
    implements TransactionContent {
        private final Map<String, Serializable> currentVariableValues;
        private final long containerInstanceId;
        private final ClassLoaderService classLoaderService;
        private final List<Operation> operations;
        private final Map<String, Serializable> operationsInputValues;

        public UpdateVariableValues(List<Operation> operations, Map<String, Serializable> operationsInputValues, Map<String, Serializable> currentVariableValues, long containerInstanceId, ClassLoaderService classLoaderService) {
            this.operations = operations;
            this.operationsInputValues = operationsInputValues;
            this.currentVariableValues = currentVariableValues;
            this.containerInstanceId = containerInstanceId;
            this.classLoaderService = classLoaderService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws SBonitaException {
            ClassLoader processClassloader = this.classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), UpdateVariableValuesThroughOperations.this.getProcessDefinitionId(this.containerInstanceId));
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(processClassloader);
                for (Operation operation : this.operations) {
                    String dataName = operation.getLeftOperand().getName();
                    for (Map.Entry<String, Serializable> variableEntry : this.currentVariableValues.entrySet()) {
                        if (!variableEntry.getKey().equals(dataName)) continue;
                        UpdateVariableValuesThroughOperations.this.executeOperation(operation, this.operationsInputValues, this.currentVariableValues, this.containerInstanceId);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }
}

