/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.synchro.AbstractJMSUpdateHandler;
import org.bonitasoft.engine.synchro.PerfEventUtil;

public class FlowNodeReachStateHandler
extends AbstractJMSUpdateHandler {
    private static final long serialVersionUID = 970281460560288990L;
    private final String identifier;
    private final int stateId;

    public FlowNodeReachStateHandler(long tenantId, long messageTimeout, int stateId) {
        super(tenantId, messageTimeout);
        this.stateId = stateId;
        this.identifier = UUID.randomUUID().toString();
    }

    @Override
    protected Map<String, Serializable> getEvent(SEvent sEvent) {
        SFlowNodeInstance flowNodeInstance = (SFlowNodeInstance)sEvent.getObject();
        return PerfEventUtil.getFlowNodeReachStateEvent(flowNodeInstance.getRootContainerId(), flowNodeInstance.getName(), this.stateId);
    }

    @Override
    public boolean isInterested(SEvent event) {
        if (event.getObject() instanceof SFlowNodeInstance) {
            SFlowNodeInstance fni = (SFlowNodeInstance)event.getObject();
            boolean interested = !fni.isStateExecuting();
            return interested &= fni.getStateId() == this.stateId;
        }
        return false;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

