/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.bonitasoft.engine.xml.SInvalidSchemaException;
import org.bonitasoft.engine.xml.SValidationException;
import org.bonitasoft.engine.xml.XMLSchemaValidator;
import org.xml.sax.SAXException;

public class SAXValidator
implements XMLSchemaValidator {
    private final SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private Schema schema;

    @Override
    public void setSchema(StreamSource source) throws SInvalidSchemaException {
        try {
            this.schema = this.factory.newSchema(source);
        }
        catch (SAXException saxe) {
            throw new SInvalidSchemaException(saxe);
        }
    }

    @Override
    public void validate(InputStream stream) throws SValidationException, IOException {
        StreamSource source = new StreamSource(stream);
        this.validate(source);
    }

    @Override
    public void validate(String filePath) throws SValidationException, IOException {
        StreamSource source = new StreamSource(filePath);
        this.validate(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(File file) throws SValidationException, IOException {
        InputStream openStream = file.toURI().toURL().openStream();
        try {
            this.validate(new StreamSource(openStream));
        }
        finally {
            openStream.close();
        }
    }

    @Override
    public void validate(Reader reader) throws SValidationException, IOException {
        StreamSource source = new StreamSource(reader);
        this.validate(source);
    }

    private void validate(StreamSource source) throws SValidationException, IOException {
        try {
            if (this.schema == null) {
                throw new SValidationException("No schema defined");
            }
            Validator validator = this.schema.newValidator();
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new SValidationException(e);
        }
    }
}

