/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.api.impl.ProcessAPIImpl;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.builder.SUserBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class ProcessInvolvementAPIImpl {
    private static final int BATCH_SIZE = 100;
    private final ProcessAPIImpl processAPI;

    public ProcessInvolvementAPIImpl(ProcessAPIImpl processAPI) {
        this.processAPI = processAPI;
    }

    public boolean isInvolvedInProcessInstance(long userId, long processInstanceId) throws ProcessInstanceNotFoundException {
        TenantServiceAccessor serviceAccessor = this.processAPI.getTenantAccessor();
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        try {
            ProcessInstance processInstance = this.processAPI.getProcessInstance(processInstanceId);
            if (userId == processInstance.getStartedBy()) {
                return true;
            }
            if (this.processAPI.searchMyAvailableHumanTasks(userId, new SearchOptionsBuilder(0, 1).filter("processInstanceId", (Serializable)Long.valueOf(processInstanceId)).done()).getCount() > 0L) {
                return true;
            }
        }
        catch (ProcessInstanceNotFoundException exc) {
            try {
                ArchivedProcessInstance archProcessInstance = this.processAPI.getLastArchivedProcessInstance(processInstanceId);
                if (userId == archProcessInstance.getStartedBy()) {
                    return true;
                }
            }
            catch (SBonitaException e) {
                throw new ProcessInstanceNotFoundException(processInstanceId);
            }
        }
        catch (SearchException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
        try {
            QueryOptions archivedQueryOptions = this.buildArchivedTasksQueryOptions(processInstanceId);
            List<SAHumanTaskInstance> sArchivedHumanTasks = activityInstanceService.searchArchivedTasks(archivedQueryOptions);
            while (!sArchivedHumanTasks.isEmpty()) {
                for (SAHumanTaskInstance sArchivedHumanTask : sArchivedHumanTasks) {
                    if (userId != sArchivedHumanTask.getAssigneeId()) continue;
                    return true;
                }
                archivedQueryOptions = QueryOptions.getNextPage(archivedQueryOptions);
                sArchivedHumanTasks = activityInstanceService.searchArchivedTasks(archivedQueryOptions);
            }
            return false;
        }
        catch (SBonitaException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public boolean isInvolvedInHumanTaskInstance(long userId, long humanTaskInstanceId) throws ActivityInstanceNotFoundException {
        try {
            return this.isInvolvedInHumanTaskInstance(userId, humanTaskInstanceId, this.processAPI.getTenantAccessor());
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException(humanTaskInstanceId);
        }
        catch (SBonitaReadException e) {
            throw new RetrieveException((Throwable)e);
        }
        catch (SActorNotFoundException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    private Boolean isInvolvedInHumanTaskInstance(long userId, long humanTaskInstanceId, TenantServiceAccessor serviceAccessor) throws SActivityInstanceNotFoundException, SActorNotFoundException, SBonitaReadException {
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        SHumanTaskInstance humanTaskInstance = activityInstanceService.getHumanTaskInstance(humanTaskInstanceId);
        long assigneeId = humanTaskInstance.getAssigneeId();
        if (assigneeId > 0L) {
            return userId == assigneeId;
        }
        return activityInstanceService.isTaskPendingForUser(humanTaskInstanceId, userId);
    }

    public boolean isManagerOfUserInvolvedInProcessInstance(long managerUserId, long processInstanceId) throws ProcessInstanceNotFoundException, BonitaException {
        TenantServiceAccessor serviceAccessor = this.processAPI.getTenantAccessor();
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        List<SUser> subordinates = this.getSubordinates(managerUserId, serviceAccessor.getIdentityService());
        try {
            try {
                ProcessInstance processInstance = this.processAPI.getProcessInstance(processInstanceId);
                if (this.isUserManagerOfProcessInstanceInitiator(managerUserId, processInstance.getStartedBy())) {
                    return true;
                }
                if (this.processAPI.searchPendingTasksManagedBy(managerUserId, new SearchOptionsBuilder(0, 1).filter("processInstanceId", (Serializable)Long.valueOf(processInstanceId)).done()).getCount() > 0L) {
                    return true;
                }
                QueryOptions queryOptions = this.buildActiveTasksQueryOptions(processInstanceId);
                List<SHumanTaskInstance> sHumanTaskInstances = activityInstanceService.searchHumanTasks(queryOptions);
                while (!sHumanTaskInstances.isEmpty()) {
                    for (SHumanTaskInstance sHumanTaskInstance : sHumanTaskInstances) {
                        if (!this.isTaskAssignedToAUserInTheList(sHumanTaskInstance, subordinates)) continue;
                        return true;
                    }
                    queryOptions = QueryOptions.getNextPage(queryOptions);
                    sHumanTaskInstances = activityInstanceService.searchHumanTasks(queryOptions);
                }
            }
            catch (ProcessInstanceNotFoundException exc) {
                try {
                    ArchivedProcessInstance archProcessInstance = this.processAPI.getLastArchivedProcessInstance(processInstanceId);
                    if (this.isUserManagerOfProcessInstanceInitiator(managerUserId, archProcessInstance.getStartedBy())) {
                        return true;
                    }
                }
                catch (SBonitaException e) {
                    throw new ProcessInstanceNotFoundException(processInstanceId);
                }
            }
            return this.isArchivedTaskDoneByOneOfTheSubordinates(processInstanceId, activityInstanceService, subordinates);
        }
        catch (SBonitaException e) {
            throw new BonitaException("Problem while searching for users involved in process instance through their manager", (Throwable)e);
        }
    }

    private QueryOptions buildActiveTasksQueryOptions(long processInstanceId) {
        SUserTaskInstanceBuilderFactory userTaskKeyFactory = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        String humanTaskIdKey = userTaskKeyFactory.getIdKey();
        String parentProcessInstanceKey = userTaskKeyFactory.getParentProcessInstanceKey();
        List<OrderByOption> orderByOptions = Arrays.asList(new OrderByOption(SHumanTaskInstance.class, humanTaskIdKey, OrderByType.ASC));
        List<FilterOption> filterOptions = Arrays.asList(new FilterOption(SHumanTaskInstance.class, parentProcessInstanceKey, processInstanceId));
        return new QueryOptions(0, 100, orderByOptions, filterOptions, null);
    }

    private QueryOptions buildArchivedTasksQueryOptions(long processInstanceId) {
        SAUserTaskInstanceBuilderFactory archUserTaskKeyFactory = BuilderFactory.get(SAUserTaskInstanceBuilderFactory.class);
        String humanTaskIdKey = archUserTaskKeyFactory.getIdKey();
        String parentProcessInstanceKey = archUserTaskKeyFactory.getParentProcessInstanceKey();
        List<OrderByOption> archivedOrderByOptions = Arrays.asList(new OrderByOption(SAHumanTaskInstance.class, humanTaskIdKey, OrderByType.ASC));
        List<FilterOption> archivedFilterOptions = Arrays.asList(new FilterOption(SAHumanTaskInstance.class, parentProcessInstanceKey, processInstanceId));
        return new QueryOptions(0, 100, archivedOrderByOptions, archivedFilterOptions, null);
    }

    private List<SUser> getSubordinates(long managerUserId, IdentityService identityService) {
        List<OrderByOption> userOrderBys = Arrays.asList(new OrderByOption(SUser.class, BuilderFactory.get(SUserBuilderFactory.class).getIdKey(), OrderByType.ASC));
        List<FilterOption> userFilters = Arrays.asList(new FilterOption(SUser.class, BuilderFactory.get(SUserBuilderFactory.class).getManagerUserIdKey(), managerUserId));
        try {
            return identityService.searchUsers(new QueryOptions(0, Integer.MAX_VALUE, userOrderBys, userFilters, null));
        }
        catch (SBonitaReadException e) {
            return Collections.emptyList();
        }
    }

    private boolean isArchivedTaskDoneByOneOfTheSubordinates(long processInstanceId, ActivityInstanceService activityInstanceService, List<SUser> subordinates) throws SBonitaReadException {
        QueryOptions archivedQueryOptions = this.buildArchivedTasksQueryOptions(processInstanceId);
        List<SAHumanTaskInstance> sArchivedHumanTasks = activityInstanceService.searchArchivedTasks(archivedQueryOptions);
        while (!sArchivedHumanTasks.isEmpty()) {
            for (SAHumanTaskInstance sArchivedHumanTask : sArchivedHumanTasks) {
                if (!this.isTaskDoneByAUserInTheList(sArchivedHumanTask, subordinates)) continue;
                return true;
            }
            archivedQueryOptions = QueryOptions.getNextPage(archivedQueryOptions);
            sArchivedHumanTasks = activityInstanceService.searchArchivedTasks(archivedQueryOptions);
        }
        return false;
    }

    private boolean isTaskDoneByAUserInTheList(SAHumanTaskInstance sArchivedHumanTask, List<SUser> users) {
        for (SUser user : users) {
            if (user.getId() != sArchivedHumanTask.getExecutedBy()) continue;
            return true;
        }
        return false;
    }

    private boolean isTaskAssignedToAUserInTheList(SHumanTaskInstance humanTask, List<SUser> users) {
        for (SUser user : users) {
            if (user.getId() != humanTask.getAssigneeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isUserManagerOfProcessInstanceInitiator(long userId, long startedByUserId) {
        SUser sUser;
        IdentityService identityService = this.processAPI.getTenantAccessor().getIdentityService();
        try {
            sUser = identityService.getUser(startedByUserId);
        }
        catch (SUserNotFoundException e) {
            return false;
        }
        return userId == sUser.getManagerUserId();
    }
}

