/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.List;
import org.bonitasoft.engine.api.impl.NodeConfiguration;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class StarterThread
extends Thread {
    private final PlatformServiceAccessor platformAccessor;
    private final SessionService sessionService;
    private final NodeConfiguration platformConfiguration;
    private final List<STenant> tenants;
    private final SessionAccessor sessionAccessor;
    private final TechnicalLoggerService technicalLoggerService;

    public StarterThread(PlatformServiceAccessor platformAccessor, SessionService sessionService, NodeConfiguration platformConfiguration, List<STenant> tenants, SessionAccessor sessionAccessor, TechnicalLoggerService technicalLoggerService) {
        super("Starter Thread");
        this.platformAccessor = platformAccessor;
        this.sessionService = sessionService;
        this.platformConfiguration = platformConfiguration;
        this.tenants = tenants;
        this.sessionAccessor = sessionAccessor;
        this.technicalLoggerService = technicalLoggerService;
        technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting elements in the Thread " + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (STenant tenant : this.tenants) {
                this.technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting elements for tenant " + tenant.getId());
                if (tenant.isPaused()) continue;
                long tenantId = tenant.getId();
                long sessionId = -1L;
                try {
                    sessionId = this.createSessionAndMakeItActive(this.platformAccessor, this.sessionAccessor, tenantId);
                    TenantServiceAccessor tenantServiceAccessor = this.platformAccessor.getTenantServiceAccessor(tenantId);
                    for (TenantRestartHandler restartHandler : this.platformConfiguration.getTenantRestartHandlers()) {
                        restartHandler.afterServicesStart(this.platformAccessor, tenantServiceAccessor);
                    }
                }
                finally {
                    this.sessionService.deleteSession(sessionId);
                }
            }
        }
        catch (RestartException e) {
            this.technicalLoggerService.log(StarterThread.class, TechnicalLogSeverity.ERROR, "Error while restarting elements", (Throwable)((Object)e));
        }
        catch (SBonitaException e) {
            this.technicalLoggerService.log(StarterThread.class, TechnicalLogSeverity.ERROR, "Error while restarting elements", e);
        }
    }

    private long createSessionAndMakeItActive(PlatformServiceAccessor platformAccessor, SessionAccessor sessionAccessor, long tenantId) throws SBonitaException {
        SessionService sessionService = platformAccessor.getSessionService();
        long sessionId = sessionService.createSession(tenantId, "system").getId();
        sessionAccessor.setSessionInfo(sessionId, tenantId);
        return sessionId;
    }
}

