/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.model.SDependency;
import org.bonitasoft.engine.dependency.model.SDependencyMapping;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.dependency.model.builder.SPlatformDependencyBuilderFactory;
import org.bonitasoft.engine.dependency.model.builder.SPlatformDependencyMappingBuilderFactory;

public class AddSPlatformCommandDependency
implements TransactionContent {
    private final DependencyService dependencyService;
    private final String name;
    private final byte[] jar;
    private final long artifactId;
    private final ScopeType artifactType;

    public AddSPlatformCommandDependency(DependencyService dependencyService, String name, byte[] jar, long artifactId, ScopeType artifactType) {
        this.dependencyService = dependencyService;
        this.name = name;
        this.jar = jar;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    @Override
    public void execute() throws SBonitaException {
        SDependency sDependency = BuilderFactory.get(SPlatformDependencyBuilderFactory.class).createNewInstance(this.name, this.name + ".jar", this.jar).done();
        this.dependencyService.createDependency(sDependency);
        SDependencyMapping sDependencyMapping = BuilderFactory.get(SPlatformDependencyMappingBuilderFactory.class).createNewInstance(sDependency.getId(), this.artifactId, this.artifactType).done();
        this.dependencyService.createDependencyMapping(sDependencyMapping);
    }
}

