/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.io.Serializable;
import java.util.List;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstances;

public class GetLastArchivedProcessInstance
implements TransactionContentWithResult<ArchivedProcessInstance> {
    private ArchivedProcessInstance processInstance;
    private final ProcessInstanceService processInstanceService;
    private final long processInstanceId;
    private final SearchEntitiesDescriptor searchEntitiesDescriptor;
    private final ProcessDefinitionService processDefinitionService;

    public GetLastArchivedProcessInstance(ProcessInstanceService processInstanceService, ProcessDefinitionService processDefinitionService, long processInstanceId, SearchEntitiesDescriptor searchEntitiesDescriptor) {
        this.processInstanceService = processInstanceService;
        this.processDefinitionService = processDefinitionService;
        this.processInstanceId = processInstanceId;
        this.searchEntitiesDescriptor = searchEntitiesDescriptor;
    }

    @Override
    public void execute() throws SBonitaException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 2);
        searchOptionsBuilder.sort("archiveDate", Order.DESC);
        searchOptionsBuilder.sort("endDate", Order.DESC);
        searchOptionsBuilder.filter("sourceObjectId", (Serializable)Long.valueOf(this.processInstanceId));
        SearchArchivedProcessInstances searchArchivedProcessInstances = new SearchArchivedProcessInstances(this.processInstanceService, this.processDefinitionService, this.searchEntitiesDescriptor.getSearchArchivedProcessInstanceDescriptor(), searchOptionsBuilder.done());
        searchArchivedProcessInstances.execute();
        List processInstances = searchArchivedProcessInstances.getResult().getResult();
        if (processInstances.isEmpty()) {
            throw new SProcessInstanceNotFoundException(this.processInstanceId);
        }
        this.processInstance = (ArchivedProcessInstance)processInstances.get(0);
    }

    @Override
    public ArchivedProcessInstance getResult() {
        return this.processInstance;
    }
}

